package com.supwisdom.dlpay.system.service

import com.supwisdom.dlpay.framework.domain.TFunction
import org.springframework.transaction.annotation.Propagation
import org.springframework.transaction.annotation.Transactional

interface CommonService{
    fun getSystemVersion(): String;
}

interface FunctionService {
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class), readOnly = true)
    fun getFunctionsByOperid(operid: String): List<TFunction>

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class), readOnly = true)
    fun getMenuTree(funcList: List<TFunction>, parentId: String): List<Map<String, Any>>


}