package com.supwisdom.dlpay.user.controller

import com.supwisdom.dlpay.consume.domain.TPerson
import com.supwisdom.dlpay.framework.ResponseBodyBuilder
import com.supwisdom.dlpay.framework.util.TradeDict
import com.supwisdom.dlpay.shop.bean.UserParam
import com.supwisdom.dlpay.user.service.UserService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.http.ResponseEntity
import org.springframework.web.bind.annotation.*

/**
 * Created by shuwei on 2019/4/15.
 */
@RestController
@RequestMapping("/api/user")
class UserController {
    @Autowired
    private lateinit var useService: UserService

    @PostMapping("/open")
    fun openAccount(@RequestBody request: UserParam): ResponseEntity<Any> {
        if (!request.uniqueId.isNullOrEmpty()) {
            val person = useService.findByThirdUniqueIdenty(request.uniqueId!!)
            if (person != null) {
                return ResponseEntity.ok(ResponseBodyBuilder.create()
                        .fail(1, "[uniqueId]该值已存在"))
            }
        }
        if (request.name.isEmpty()) {
            return ResponseEntity.ok(ResponseBodyBuilder.create()
                    .fail(1, "[name]不能为空"))
        }
        val person = TPerson()
        person.addr = request.addr
        person.name = request.name
        person.mobile = request.mobile
        person.status = TradeDict.STATUS_NORMAL
        person.thirdUniqueIdenty = request.uniqueId
        useService.save(person)
        return ResponseEntity.ok(ResponseBodyBuilder.create()
                .data("userid", person.userid)
                .success())
    }

    @PostMapping("/get")
    fun queryShop(@RequestBody request: UserParam): ResponseEntity<Any> {
        if (!request.uniqueId.isNullOrEmpty()) {
            val person = useService.findByThirdUniqueIdenty(request.uniqueId!!)
            if (person != null) {
                val account = useService.findAccountByUserid(person.userid)
                return ResponseEntity.ok(ResponseBodyBuilder.create()
                        .data("person", person)
                        .data("account", account!!)
                        .success())
            }
        } else if (!request.userid.isNullOrEmpty()) {
            val person = useService.findPersonByUserid(request.userid!!)
            if (person != null) {
                val account = useService.findAccountByUserid(person.userid)
                return ResponseEntity.ok(ResponseBodyBuilder.create()
                        .data("person", person)
                        .data("account", account!!)
                        .success())
            }
        }
        return ResponseEntity.ok(ResponseBodyBuilder.create()
                .fail(1, "数据不存在"))
    }
}