package com.supwisdom.dlpay.api.dao;

import com.supwisdom.dlpay.api.domain.TShopPaytypeConfig;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface ShopPaytypeConfigDao extends JpaRepository<TShopPaytypeConfig, String> {
  @Query("select a from TShopPaytypeConfig a where a.paytype=?1 and a.shopaccno=?2 ")
  List<TShopPaytypeConfig> getShopPaytypeConfigs(String paytype, String shopaccno);

  @Query("select a from TShopPaytypeConfig a where a.shopaccno=?1 and a.paytype=?2 and a.configid=?3 ")
  TShopPaytypeConfig getShopPaytypeConfigById(String shopaccno,String paytype, String configid);
}
