package com.supwisdom.dlpay.framework.domain;

import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

@Entity
@Table(name = "TB_SETTLE_LOG")
public class TSettleLog {
  @Id
  @GenericGenerator(name = "idGenerator", strategy = "uuid")
  @GeneratedValue(generator = "idGenerator")
  @Column(name = "ID", nullable = false, length = 32)
  private String id;

  @Column(name = "STARTTIME", length = 14)
  private String starttime;

  @Column(name = "ENDTIME", length = 14)
  private String endtime;

  @Column(name = "ERRCODE", length = 10)
  private String errcode;

  @Column(name = "ERRMSG", length = 600)
  private String errmsg;

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public String getStarttime() {
    return starttime;
  }

  public void setStarttime(String starttime) {
    this.starttime = starttime;
  }

  public String getEndtime() {
    return endtime;
  }

  public void setEndtime(String endtime) {
    this.endtime = endtime;
  }

  public String getErrcode() {
    return errcode;
  }

  public void setErrcode(String errcode) {
    this.errcode = errcode;
  }

  public String getErrmsg() {
    return errmsg;
  }

  public void setErrmsg(String errmsg) {
    this.errmsg = errmsg;
  }

  public TSettleLog update(String errcode, String errmsg) {
    this.errcode = errcode;
    this.errmsg = errmsg;
    return this;
  }
}
