package com.supwisdom.dlpay.system.controller;

import com.supwisdom.dlpay.api.bean.JsonResult;
import com.supwisdom.dlpay.api.domain.TAccount;
import com.supwisdom.dlpay.api.domain.TPerson;
import com.supwisdom.dlpay.api.domain.TPersonIdentity;
import com.supwisdom.dlpay.api.domain.TPointsAccount;
import com.supwisdom.dlpay.framework.domain.TOperator;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.framework.util.WebConstant;
import com.supwisdom.dlpay.system.bean.IdTypeBean;
import com.supwisdom.dlpay.system.bean.PersonParamBean;
import com.supwisdom.dlpay.system.service.UserDataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@Controller
public class UserController {
    @Autowired
    private UserDataService userDataService;

    @GetMapping("/user/index")
    public String index() {
        return "system/user/index";
    }

    @GetMapping("/user/list")
    @PreAuthorize("hasPermission('/user/list','')")
    @ResponseBody
    public PageResult<TPerson> getDataList(@RequestParam("page") Integer pageNo,
                                           @RequestParam("limit") Integer pageSize,
                                           @RequestParam(value = "searchkey", required = false) String searchKey) {
        try {
            if (null == pageNo || pageNo < 1) pageNo = WebConstant.PAGENO_DEFAULT;
            if (null == pageSize || pageSize < 1) pageSize = WebConstant.PAGESIZE_DEFAULT;
            PersonParamBean searchBean = new PersonParamBean();
            searchBean.setPageNo(pageNo);
            searchBean.setName(searchKey);
            searchBean.setPageSize(pageSize);
            return userDataService.getPersonsByKey(searchBean);
        } catch (Exception e) {
            e.printStackTrace();
            return new PageResult<>(99, "系统查询错误");
        }
    }

    @GetMapping("/user/loadadd")
    public String add(ModelMap map) {
        List<IdTypeBean> list = new ArrayList<>();
        list.add(new IdTypeBean("1", "身份证"));
        list.add(new IdTypeBean("2", "护照"));
        list.add(new IdTypeBean("3", "驾照"));
        list.add(new IdTypeBean("4", "港澳通行证"));
        list.add(new IdTypeBean("5", "学工号"));
        list.add(new IdTypeBean("9", "其他"));
        map.put("idtypes", list);
        return "system/user/add";
    }

    @PostMapping("/user/add")
    @PreAuthorize("hasPermission('/user/add','')")
    @ResponseBody
    public JsonResult add(@RequestBody TPerson person) {
        if (StringUtil.isEmpty(person.getName())
                || StringUtil.isEmpty(person.getSex())
                || StringUtil.isEmpty(person.getIdno())
                || StringUtil.isEmpty(person.getIdtype())
                || StringUtil.isEmpty(person.getMobile())) {
            return JsonResult.error("参数错误");
        }
        return userDataService.saveUser(person);
    }

    @PostMapping("/user/del")
    @PreAuthorize("hasPermission('/user/del','')")
    @ResponseBody
    public JsonResult del(@RequestParam String userid) {
        if (StringUtil.isEmpty(userid)) {
            return JsonResult.error("参数错误");
        }
        return userDataService.deleteUser(userid);
    }

    @GetMapping("/user/acc")
    public String acc() {
        return "system/user/account";
    }

    @GetMapping("/user/account")
    @PreAuthorize("hasPermission('/user/account','')")
    @ResponseBody
    public PageResult<TAccount> getDataAccountList(@RequestParam("page") Integer pageNo,
                                                   @RequestParam("limit") Integer pageSize,
                                                   @RequestParam(value = "searchkey", required = false) String searchKey) {
        try {
            if (null == pageNo || pageNo < 1) pageNo = WebConstant.PAGENO_DEFAULT;
            if (null == pageSize || pageSize < 1) pageSize = WebConstant.PAGESIZE_DEFAULT;
            PersonParamBean searchBean = new PersonParamBean();
            searchBean.setPageNo(pageNo);
            searchBean.setName(searchKey);
            searchBean.setPageSize(pageSize);
            return userDataService.getAccountsByKey(searchBean);
        } catch (Exception e) {
            e.printStackTrace();
            return new PageResult<>(99, "系统查询错误");
        }
    }

    @GetMapping("/user/point")
    public String point() {
        return "system/user/point";
    }

    @GetMapping("/user/pointlist")
    @PreAuthorize("hasPermission('/user/pointlist','')")
    @ResponseBody
    public PageResult<TPointsAccount> getDataPointList(@RequestParam("page") Integer pageNo,
                                                       @RequestParam("limit") Integer pageSize,
                                                       @RequestParam(value = "searchkey", required = false) String searchKey) {
        try {
            if (null == pageNo || pageNo < 1) pageNo = WebConstant.PAGENO_DEFAULT;
            if (null == pageSize || pageSize < 1) pageSize = WebConstant.PAGESIZE_DEFAULT;
            PersonParamBean searchBean = new PersonParamBean();
            searchBean.setPageNo(pageNo);
            searchBean.setName(searchKey);
            searchBean.setPageSize(pageSize);
            return userDataService.getPointsByKey(searchBean);
        } catch (Exception e) {
            e.printStackTrace();
            return new PageResult<>(99, "系统查询错误");
        }
    }

    @PostMapping("/user/delacc")
    @PreAuthorize("hasPermission('/user/delacc','')")
    @ResponseBody
    public JsonResult delacc(@RequestParam String accno) {
        if (StringUtil.isEmpty(accno)) {
            return JsonResult.error("参数错误");
        }
        return userDataService.closeAccount(accno);
    }
    @PostMapping("/user/delpoint")
    @PreAuthorize("hasPermission('/user/delpoint','')")
    @ResponseBody
    public JsonResult delpoint(@RequestParam String userid) {
        if (StringUtil.isEmpty(userid)) {
            return JsonResult.error("参数错误");
        }
        return userDataService.deletePoint(userid);
    }
    @GetMapping("/user/pointdtl")
    public String pointdtl(@RequestParam String userid,ModelMap map) {
        map.put("userid",userid);
        return "system/user/pointdtl";
    }
}
