package com.supwisdom.dlpay.api.service

import com.supwisdom.dlpay.api.TransactionBuilder
import com.supwisdom.dlpay.api.domain.TTransactionMain
import org.springframework.transaction.annotation.Propagation
import org.springframework.transaction.annotation.Transactional

interface TransactionService {
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = [Exception::class])
    fun init(builder: TransactionBuilder): TTransactionMain

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = [Exception::class])
    fun wip(refno: String): TTransactionMain

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = [Exception::class])
    fun wip(builder: TransactionBuilder): TTransactionMain

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = [Exception::class])
    fun fail(refno: String): TTransactionMain

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = [Exception::class])
    fun fail(refno: String, remark: String): TTransactionMain

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = [Exception::class])
    fun success(refno: String): TTransactionMain

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = [Exception::class])
    fun success(refno: String, remark: String): TTransactionMain

    // 撤销接口冲正类接口
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = [Exception::class])
    fun reverse(originRefno: String): TTransactionMain

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = [Exception::class])
    fun reverseInit(originRefno: String): TTransactionMain

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = [Exception::class])
    fun reverseConfirm(refno: String): TTransactionMain

    fun reverseFail(refno: String): TTransactionMain

    // 冲正类接口
    /**
     * 冲正业务
     */
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = [Exception::class])
    fun cancel(originRefno: String): TTransactionMain

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = [Exception::class])
    fun cancelInit(originRefno: String): TTransactionMain

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = [Exception::class])
    fun cancelConfirm(refno: String): TTransactionMain

    fun cancelFail(refno: String): TTransactionMain

    // 补帐接口
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = [Exception::class])
    fun repair(refno: String, remark: String): TTransactionMain
}
