package com.supwisdom.dlpay

import org.springframework.beans.factory.annotation.Autowired
import org.springframework.context.annotation.Configuration
import org.springframework.data.redis.connection.RedisConnectionFactory
import org.springframework.security.authentication.AuthenticationManager
import org.springframework.security.oauth2.config.annotation.configurers.ClientDetailsServiceConfigurer
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurerAdapter
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableAuthorizationServer
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerEndpointsConfigurer
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerSecurityConfigurer
import org.springframework.security.oauth2.config.annotation.web.configurers.ResourceServerSecurityConfigurer
import org.springframework.security.oauth2.provider.ClientDetails
import org.springframework.security.oauth2.provider.ClientDetailsService
import org.springframework.security.oauth2.provider.token.store.redis.RedisTokenStore


class OAuthDetailService : ClientDetailsService {

    override fun loadClientByClientId(clientId: String?): ClientDetails {
        TODO("not implemented") //To change body of created functions use File | Settings | File Templates.
    }
}

@Configuration
class OAuth2Config {
    @Configuration
    @EnableResourceServer
    class ResourceServerConfiguration : ResourceServerConfigurerAdapter() {
        override fun configure(resources: ResourceServerSecurityConfigurer?) {
            resources?.resourceId("payapi")?.stateless(true)
        }
    }

    @Configuration
    @EnableAuthorizationServer
    class AuthorizationServerConfigure : AuthorizationServerConfigurerAdapter() {

        @Autowired
        private lateinit var redisConnectionFactory: RedisConnectionFactory

        @Autowired
        private lateinit var authenticationManager: AuthenticationManager

        override fun configure(security: AuthorizationServerSecurityConfigurer?) {
            security?.allowFormAuthenticationForClients()
        }

        override fun configure(clients: ClientDetailsServiceConfigurer?) {
            clients?.withClientDetails(OAuthDetailService())
        }

        override fun configure(endpoints: AuthorizationServerEndpointsConfigurer?) {
            endpoints?.tokenStore(RedisTokenStore(redisConnectionFactory))
                    ?.authenticationManager(authenticationManager)
        }
    }
}