package com.supwisdom.dlpay.consume

import com.google.gson.Gson
import com.sun.jersey.api.client.Client
import com.sun.jersey.api.client.ClientResponse
import com.supwisdom.dlpay.consume.bean.BaseResp
import com.supwisdom.dlpay.consume.bean.SupStatusRevResp
import com.supwisdom.dlpay.consume.bean.SupYktResp
import com.supwisdom.dlpay.consume.domain.TUserdtl
import com.supwisdom.dlpay.framework.util.MoneyUtil
import com.supwisdom.dlpay.util.HmacUtil

/**
 * Created by shuwei on 2019/4/11.
 */
class CallService {

    companion object {
        fun callYktPay(config: Map<String, String>, paydtl: TUserdtl, time: String,stuempno: String, yktshopid: String, devphyid: String?): BaseResp {
            val code = BaseResp()

            val appid = config["appid"]
            val appkey = config["appkey"]
            val orderurl = config["orderurl"]

            val params = hashMapOf<String, String?>()
            params.put("partner_id", appid)
            params.put("stuempno", stuempno)
            params.put("tradeno", paydtl.refno)
            params.put("tradename", paydtl.payinfo)
            params.put("amount", MoneyUtil.YuanToFen(paydtl.amount).toString())
            params.put("shopid", yktshopid)
            params.put("devphyid", devphyid)
            params.put("calcmanagefee", "T") //是否计算费率
            params.put("timestamp", time)
            params.put("sign_method", "HMAC");
            params.put("limitflag", "off") //是否判断消费限额，on-判断；off-不判断。默认on（判断限额）。为空或不为off都是on；
            var signstr = HmacUtil.createLinkString(HmacUtil.paraFilter(params))
            val sign = HmacUtil.HMACSHA1(signstr, appkey)
            signstr = "$signstr&sign=$sign&sourcetype=food"
            val c = Client.create()
            c.setConnectTimeout(20000)
            val r = c.resource(orderurl)
            val respClient = r.post(ClientResponse::class.java, signstr)
            if (200 == respClient.status) {
                val ret = respClient.getEntity(String::class.java)
                if (ret != null) {
                    try {
                        val gson = Gson()
                        val result = gson.fromJson(ret, SupYktResp::class.java)
                        if (result == null) {
                            code.retcode = "1"
                            code.retmsg = "返回内容为空"
                            return code
                        }
                        if ("0" != result.retcode) {
                            if ("30" == result.retcode) {
                                if (result.other != null) {
                                    try {
                                        val supStatusRevResp = gson.fromJson(result.other,
                                                SupStatusRevResp::class.java)
                                        if (supStatusRevResp != null) {
                                            //同流水号，同一笔已经支付完成的，不重复支付。
                                            if (3 == supStatusRevResp.status
                                                    && supStatusRevResp.revflag != null
                                                    && !supStatusRevResp.revflag) {
                                                code.retcode = "0"
                                                code.retmsg = "成功"
                                                return code
                                            }
                                        }
                                    } catch (e: Exception) {
                                        e.printStackTrace()
                                    }
                                }
                            }
                            code.retcode = "1"
                            code.retmsg = "交易失败:" + result.retmsg
                            return code
                        }
                        code.retcode = "0"
                        code.retmsg = "成功"
                        return code
                    } catch (e: Exception) {
                        e.printStackTrace()
                    }
                }
            }
            code.retcode = "1"
            code.retmsg = "请求失败"
            return code
        }
    }
}