package com.supwisdom.dlpay.api.domain;

import javax.persistence.*;

@Entity
@Table(name = "TB_SHOPDTL",
    indexes = {@Index(name = "shopdtl_accdate", columnList = "accdate"),
        @Index(name = "shopdtl_shopaccno", columnList = "shopaccno"),
        @Index(name = "shopdtl_transdate", columnList = "transdate")})
public class TShopdtl {
  @Id
  @Column(name = "refno", length = 32, nullable = false)
  private String refno;

  @Column(name = "accdate", length = 8, nullable = false)
  private String accdate;

  @Column(name = "shopaccno", length = 10, nullable = false)
  private String shopaccno;

  @Column(name = "shopname", length = 200)
  private String shopname;

  @Column(name = "amount", scale = 2, precision = 15)
  private Double amount;

  @Column(name = "transdate", length = 8)
  private String transDate;

  @Column(name = "transtime", length = 6)
  private String transTime;

  @Column(name = "tradecode", precision = 8)
  private Integer tradeCode;

  @Column(name = "paytype", length = 20)
  private String payType;

  @Column(name = "payinfo", length = 200)
  private String payInfo;

  @Column(name = "status", length = 20)
  private String status;

  @Column(name = "OPPOSITEACCNO", length = 20)
  private String oppositeAccNo;

  @Column(name = "OPPOSITEACCNAME", length = 200)
  private String oppositeAccName;

  public String getRefno() {
    return refno;
  }

  public void setRefno(String refno) {
    this.refno = refno;
  }

  public String getAccdate() {
    return accdate;
  }

  public void setAccdate(String accdate) {
    this.accdate = accdate;
  }

  public String getShopaccno() {
    return shopaccno;
  }

  public void setShopaccno(String shopaccno) {
    this.shopaccno = shopaccno;
  }

  public String getShopname() {
    return shopname;
  }

  public void setShopname(String shopname) {
    this.shopname = shopname;
  }

  public Double getAmount() {
    return amount;
  }

  public void setAmount(Double amount) {
    this.amount = amount;
  }

  public String getTransDate() {
    return transDate;
  }

  public void setTransDate(String transDate) {
    this.transDate = transDate;
  }

  public String getTransTime() {
    return transTime;
  }

  public void setTransTime(String transTime) {
    this.transTime = transTime;
  }

  public String getPayType() {
    return payType;
  }

  public void setPayType(String payType) {
    this.payType = payType;
  }

  public String getPayInfo() {
    return payInfo;
  }

  public void setPayInfo(String payInfo) {
    this.payInfo = payInfo;
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public String getOppositeAccNo() {
    return oppositeAccNo;
  }

  public void setOppositeAccNo(String oppositeAccNo) {
    this.oppositeAccNo = oppositeAccNo;
  }

  public String getOppositeAccName() {
    return oppositeAccName;
  }

  public void setOppositeAccName(String oppositeAccName) {
    this.oppositeAccName = oppositeAccName;
  }

  public Integer getTradeCode() {
    return tradeCode;
  }

  public void setTradeCode(Integer tradeCode) {
    this.tradeCode = tradeCode;
  }
}
