package com.supwisdom.dlpay.framework.dao;

import com.supwisdom.dlpay.framework.domain.TVoucherEntry;
import com.supwisdom.dlpay.framework.domain.TVoucherEntryPK;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import javax.persistence.LockModeType;
import java.util.List;

@Repository
public interface VoucherEntryDao extends JpaRepository<TVoucherEntry,TVoucherEntryPK> {
  @Query(value = "delete from TB_VOUCHERENTRY where VOUCHERID in (select VOUCHERID from TB_VOUCHER where POSTFLAG=0)", nativeQuery = true)
  void deleteUnpostVoucherentry();

  @Query(value = "from TVoucherEntry where voucherid in (select voucherid from TVoucher where voucherdate=:voucherdate) order by subjno,accno,voucherid ")
  List<TVoucherEntry> getVoucherEntryByVoucherdate(@Param("voucherdate") Integer voucherdate);

  @Lock(LockModeType.PESSIMISTIC_WRITE)
  @Query(value = "from TVoucherEntry t where t.voucherid=:voucherid ")
  List<TVoucherEntry> getVoucherEntryByVoucherid(@Param("voucherid")String voucherid);
}
