package com.supwisdom.dlpay.framework.domain;

import javax.persistence.*;

@Entity
@Table(name = "TB_SUBJECTDAY")
@IdClass(TSubjectdayPK.class)
public class TSubjectday {
  @Id
  @Column(name="ACCDATE", nullable = false, length = 8)
  private String accdate;

  @Id
  @Column(name="SUBJNO", nullable = false, length = 10)
  private String subjno;

  @Column(name="PERIOD_YEAR", precision = 4)
  private Integer periodYear;

  @Column(name="PERIOD_MONTH", precision = 2)
  private Integer periodMonth;

  @Column(name="BEGINDRBAL", precision = 15, scale = 2)
  private Double begindrbal;

  @Column(name="BEGINCRBAL", precision = 15, scale = 2)
  private Double begincrbal;

  @Column(name="DRAMT", precision = 15, scale = 2)
  private Double dramt;

  @Column(name="CRAMT", precision = 15, scale = 2)
  private Double cramt;

  @Column(name="DRBAL", precision = 15, scale = 2)
  private Double drbal;

  @Column(name="CRBAL", precision = 15, scale = 2)
  private Double crbal;

  @Column(name="UPDTIME", precision = 15, scale = 2)
  private String updtime;

  public TSubjectday() {
  }

  public TSubjectday(String accdate, String subjno, Integer periodYear, Integer periodMonth, Double begindrbal, Double begincrbal, Double dramt, Double cramt, Double drbal, Double crbal) {
    this.accdate = accdate;
    this.subjno = subjno;
    this.periodYear = periodYear;
    this.periodMonth = periodMonth;
    this.begindrbal = begindrbal;
    this.begincrbal = begincrbal;
    this.dramt = dramt;
    this.cramt = cramt;
    this.drbal = drbal;
    this.crbal = crbal;
  }

  public TSubjectday(String accdate, String subjno, Integer periodYear, Integer periodMonth, Double begindrbal, Double begincrbal, Double dramt, Double cramt, Double drbal, Double crbal, String updtime) {
    this.accdate = accdate;
    this.subjno = subjno;
    this.periodYear = periodYear;
    this.periodMonth = periodMonth;
    this.begindrbal = begindrbal;
    this.begincrbal = begincrbal;
    this.dramt = dramt;
    this.cramt = cramt;
    this.drbal = drbal;
    this.crbal = crbal;
    this.updtime = updtime;
  }

  public String getAccdate() {
    return accdate;
  }

  public void setAccdate(String accdate) {
    this.accdate = accdate;
  }

  public String getSubjno() {
    return subjno;
  }

  public void setSubjno(String subjno) {
    this.subjno = subjno;
  }

  public Integer getPeriodYear() {
    return periodYear;
  }

  public void setPeriodYear(Integer periodYear) {
    this.periodYear = periodYear;
  }

  public Integer getPeriodMonth() {
    return periodMonth;
  }

  public void setPeriodMonth(Integer periodMonth) {
    this.periodMonth = periodMonth;
  }

  public Double getBegindrbal() {
    return begindrbal;
  }

  public void setBegindrbal(Double begindrbal) {
    this.begindrbal = begindrbal;
  }

  public Double getBegincrbal() {
    return begincrbal;
  }

  public void setBegincrbal(Double begincrbal) {
    this.begincrbal = begincrbal;
  }

  public Double getDramt() {
    return dramt;
  }

  public void setDramt(Double dramt) {
    this.dramt = dramt;
  }

  public Double getCramt() {
    return cramt;
  }

  public void setCramt(Double cramt) {
    this.cramt = cramt;
  }

  public Double getDrbal() {
    return drbal;
  }

  public void setDrbal(Double drbal) {
    this.drbal = drbal;
  }

  public Double getCrbal() {
    return crbal;
  }

  public void setCrbal(Double crbal) {
    this.crbal = crbal;
  }

  public String getUpdtime() {
    return updtime;
  }

  public void setUpdtime(String updtime) {
    this.updtime = updtime;
  }
}
