package com.supwisdom.dlpay.api.controller

import com.supwisdom.dlpay.api.PersonTransBuilder
import com.supwisdom.dlpay.api.service.AccountUtilServcie
import com.supwisdom.dlpay.api.service.PaytypeService
import com.supwisdom.dlpay.api.service.PersonBalancePayService
import com.supwisdom.dlpay.framework.util.MD5
import com.supwisdom.dlpay.framework.util.StringUtil
import com.supwisdom.dlpay.framework.util.TradeDict
import com.supwisdom.dlpay.framework.util.XmlUtils
import com.supwisdom.dlpay.util.PaytypeUtil
import org.dom4j.io.SAXReader
import org.slf4j.LoggerFactory
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.util.StringUtils
import org.springframework.web.bind.annotation.PathVariable
import org.springframework.web.bind.annotation.RequestMapping
import org.springframework.web.bind.annotation.ResponseBody
import org.springframework.web.bind.annotation.RestController
import java.util.HashMap
import javax.servlet.http.HttpServletRequest
import javax.servlet.http.HttpServletResponse

/**
 * Created by shuwei on 2019/4/22.
 */
@RestController
@RequestMapping("/api/notify")
class NotifyController {
    private val logger = LoggerFactory.getLogger(NotifyController::class.java)
    @Autowired
    lateinit var personBalancePayService: PersonBalancePayService
    @Autowired
    lateinit var paytypeService: PaytypeService
    @Autowired
    lateinit var accountUtilServcie: AccountUtilServcie

    @RequestMapping(value = ["/wechat"])
    @ResponseBody
    fun index(@PathVariable schema: String, request: HttpServletRequest,
              response: HttpServletResponse): String {
        try {
            // 解析结果存储在HashMap
            var map: MutableMap<String, String> = HashMap()
            val inputStream = request.inputStream
            // 读取输入流
            val reader = SAXReader()
            val document = reader.read(inputStream)
            // 得到xml根元素
            val root = document.rootElement
            // 得到根元素的所有子节点
            val elementList = root.elements()
            // 遍历所有子节点
            for (e in elementList) {
                map[e.name] = e.text
                logger.error("*************" + e.name + "=" + e.text + "************************")
            }
            // 释放资源
            inputStream.close()

            val sign = map["sign"]
            if (StringUtils.isEmpty(sign)) {
                logger.error("签名错误")
                return "<xml><return_code><![CDATA[FAIL]]></return_code><return_msg><![CDATA[签名错误]]></return_msg></xml>"
            }
            map = StringUtil.paraFilter(map)
            //TODO 校验签名
            var signStr = StringUtil.createLinkString(map)
            val config = paytypeService.getPaytypeConfigByPaytype(PaytypeUtil.WECHAT)
            if (config["appkey"].isNullOrEmpty()) {
                logger.error("签名错误")
                return "<xml><return_code><![CDATA[FAIL]]></return_code><return_msg><![CDATA[签名错误]]></return_msg></xml>"
            }
            val key = config["appkey"]
            signStr += "&key=$key"
            val signRet = MD5.encodeByMD5(signStr)
            logger.error("*******signStr=$signStr")
            if (!signRet.equals(sign, ignoreCase = true)) {
                return "<xml><return_code><![CDATA[FAIL]]></return_code><return_msg><![CDATA[签名失败]]></return_msg></xml>"
            }
            logger.error("*******signRet=$signRet,sign=$sign*****************")
            val return_code = map["return_code"]
            val result_code = map["result_code"]
            val out_trade_no = map["out_trade_no"]
            if (StringUtils.isEmpty(out_trade_no)) {
                return "<xml><return_code><![CDATA[FAIL]]></return_code><return_msg><![CDATA[订单信息错误]]></return_msg></xml>"
            }
            if (!StringUtils.isEmpty(return_code) && "SUCCESS" == return_code
                    && !StringUtils.isEmpty(result_code) && "SUCCESS" == result_code) {
                //map.get("transaction_id") 第三方流水号
                PersonTransBuilder.newBuilder(accountUtilServcie)
                        .setRefno(out_trade_no!!)
                        .addResult(map)
                        .success(personBalancePayService)
            }
            return "<xml><return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[OK]]></return_msg></xml>"
        } catch (e: Exception) {
            e.printStackTrace()
            logger.error("------------step7----------------" + e.message)
            return "<xml><return_code><![CDATA[FAIL]]></return_code><return_msg><![CDATA[解析失败]]></return_msg></xml>"
        }
    }
}