package com.supwisdom.dlpay.api.service.impl

import com.supwisdom.dlpay.api.dao.PaytypeDao
import com.supwisdom.dlpay.api.dao.ShopPaytypeConfigDao
import com.supwisdom.dlpay.api.dao.ShopPaytypeDao
import com.supwisdom.dlpay.api.dao.UserdtlBusinessDao
import com.supwisdom.dlpay.api.domain.TUserdtlBusiness
import com.supwisdom.dlpay.api.service.ConsumePayService
import com.supwisdom.dlpay.exception.TransactionProcessException
import com.supwisdom.dlpay.framework.util.TradeErrorCode
import com.supwisdom.dlpay.util.ConstantUtil
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

@Service
class ConsumePayServiceImpl: ConsumePayService{
    @Autowired
    lateinit var paytypeDao: PaytypeDao
    @Autowired
    lateinit var shopPaytypeDao: ShopPaytypeDao
    @Autowired
    lateinit var shopPaytypeConfigDao: ShopPaytypeConfigDao
    @Autowired
    lateinit var userdtlBusinessDao: UserdtlBusinessDao

    override fun checkShopPaytype(shopaccno: String, paytype: String, anonymousflag: Boolean?): Boolean{
        paytypeDao.getByPaytype(paytype).let {
            if (null == it) {
                throw TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "系统不支持支付方式[$paytype]")
            } else {
                if (ConstantUtil.ENABLE_YES != it.enable || ConstantUtil.ENABLE_YES != it.consumeEnable) {
                    throw TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "系统未启用支付方式[$paytype]消费")
                }
                if (true == anonymousflag && ConstantUtil.ENABLE_YES != it.anonymousEnable) {
                    throw TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "系统支付方式[$paytype]未启用匿名消费")
                }
            }
        }
        shopPaytypeDao.getById(paytype, shopaccno).let {
            if (null == it) {
                throw TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "该商户[$shopaccno]未启用支付方式[$paytype]")
            } else {
                if (ConstantUtil.ENABLE_YES != it.consumeEnable) {
                    throw TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "该商户[$shopaccno]未启用支付方式[$paytype]")
                }
                if (true == anonymousflag && ConstantUtil.ENABLE_YES != it.anonymousEnable) {
                    throw TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "该商户[$shopaccno]的支付方式[$paytype]未启用匿名消费")
                }
            }
        }
        return true
    }

    override fun getPaytypeConfig(paytype: String, shopaccno: String, anonymousflag: Boolean?, ignoreStatus: Boolean?): Map<String, String?> {
        paytypeDao.getByPaytype(paytype).let {
            if (null == it) {
                throw TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "系统不支持支付方式[$paytype]")
            } else {
                //对账取配置时不关心状态，不能报错
                if (true != ignoreStatus && (ConstantUtil.ENABLE_YES != it.enable || ConstantUtil.ENABLE_YES != it.consumeEnable)) {
                    throw TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "系统未启用支付方式[$paytype]消费")
                }
                if (true != ignoreStatus && true == anonymousflag && ConstantUtil.ENABLE_YES != it.anonymousEnable) {
                    throw TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "系统支付方式[$paytype]未启用匿名消费")
                }
            }
        }

        shopPaytypeDao.getById(paytype, shopaccno).let {
            if (null == it) {
                throw TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "该商户[$shopaccno]未启用支付方式[$paytype]")
            } else {
                //对账取配置时不关心状态，不能报错
                if (true != ignoreStatus && ConstantUtil.ENABLE_YES != it.consumeEnable) {
                    throw TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "该商户[$shopaccno]未启用支付方式[$paytype]")
                }
                if (true != ignoreStatus && true == anonymousflag && ConstantUtil.ENABLE_YES != it.anonymousEnable) {
                    throw TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "该商户[$shopaccno]的支付方式[$paytype]未启用匿名消费")
                }
            }
        }

        shopPaytypeConfigDao.getShopPaytypeConfigs(paytype, shopaccno)?.let {
            if (it.size < 1) {
                throw TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "该商户[$shopaccno]的支付方式[$paytype]未配置参数")
            } else {
                val result = mutableMapOf<String, String?>()
                it.forEach { result.plus(mapOf(it.configid to it.configValue)) }
                return result
            }
        } ?: throw TransactionProcessException(TradeErrorCode.INPUT_DATA_ERROR, "该商户[$shopaccno]的支付方式[$paytype]未配置参数")
    }

    override fun getUserdtlExtendParamMap(refno: String): Map<String, String> {
        return userdtlBusinessDao.getByRefno(refno)?.let {
            it.contentMap
        } ?: mutableMapOf<String, String>()
    }
}