package com.supwisdom.dlpay.controller

import com.google.gson.Gson
import com.supwisdom.dlpay.MvcBaseTest
import com.supwisdom.dlpay.api.bean.OpenShopParam
import com.supwisdom.dlpay.api.bean.QueryShopParam
import com.supwisdom.dlpay.framework.domain.TShop
import org.junit.Assert
import org.junit.Test
import org.springframework.http.MediaType
import org.springframework.test.context.ActiveProfiles

import org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post
import org.springframework.test.web.servlet.result.MockMvcResultHandlers.print
import org.springframework.test.web.servlet.result.MockMvcResultMatchers.status

/**
 * Created by shuwei on 2019/4/15.
 */
@ActiveProfiles("devel-pg")
class ShopControllerTest : MvcBaseTest() {
    class RetBean {
        var shopid: Int = 0
        var retcode: Int = 0
        lateinit var shop: TShop
    }

    @Test
    fun open() {
        val shopParam = OpenShopParam()
        shopParam.shopUniqueId = "ykt_shop_20001"
        shopParam.shopname = "测试名称"
        val gson = Gson()
        val ret = mvc.perform(post("/api/shop/open").content(gson.toJson(shopParam))
                .contentType(MediaType.APPLICATION_JSON))
                .andExpect(status().isOk)
                .andDo(print())
                .andReturn()
        val res = ret.response.contentAsString
        Assert.assertNotNull(res)
        val retBean = gson.fromJson(res, RetBean::class.java)
        Assert.assertNotNull(retBean)
        Assert.assertEquals(0, retBean.retcode)
        Assert.assertNotNull(retBean.shopid)
        Assert.assertNotEquals(0, retBean.shopid)
    }

    @Test
    fun get() {
        val shopParam = QueryShopParam()
        shopParam.shopUniqueId = "ykt_shop_20001"
        val gson = Gson()
        val ret = mvc.perform(post("/shop/open").content(gson.toJson(shopParam))
                .contentType(MediaType.APPLICATION_JSON))
                .andExpect(status().isOk)
                .andDo(print())
                .andReturn()
        val resOpen = ret.response.contentAsString
        Assert.assertNotNull(resOpen)
        val retBeanOpen = gson.fromJson(resOpen, RetBean::class.java)
        Assert.assertNotNull(retBeanOpen)
        Assert.assertNotNull(retBeanOpen.shopid)
        shopParam.shopid = retBeanOpen.shopid

        val retGet = mvc.perform(get("/shop/get").content(gson.toJson(shopParam))
                .contentType(MediaType.APPLICATION_JSON))
                .andExpect(status().isOk)
                .andDo(print())
                .andReturn()
        val res = retGet.response.contentAsString
        Assert.assertNotNull(res)
        val retBean = gson.fromJson(res, RetBean::class.java)
        Assert.assertNotNull(retBean)
        Assert.assertEquals(0, retBean.retcode)
        Assert.assertNotNull(retBean.shop)
        Assert.assertEquals(retBeanOpen.shopid, retBean.shop.shopid)
    }
}