package com.supwisdom.dlpay.framework.dao;

import com.supwisdom.dlpay.framework.domain.TPeriod;
import com.supwisdom.dlpay.framework.domain.TPeriodPK;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import javax.persistence.LockModeType;

@Repository
public interface PeriodDao extends JpaRepository<TPeriod, TPeriodPK> {
  @Query(value = "from TPeriod t where t.periodYear=:periodyear and t.periodMonth=:periodmonth ")
  TPeriod getPeriod(@Param("periodyear") Integer periodyear, @Param("periodmonth") Integer periodmonth);

  @Lock(LockModeType.PESSIMISTIC_WRITE)
  @Query(value = "from TPeriod t where t.periodYear=:periodyear and t.periodMonth=:periodmonth ")
  TPeriod getTPeriodWithLock(@Param("periodyear") Integer periodyear, @Param("periodmonth") Integer periodmonth);
}
