package com.supwisdom.dlpay.framework.dao;

import com.supwisdom.dlpay.framework.data.FSubjectInfoBean;
import com.supwisdom.dlpay.framework.data.MerchBean;
import com.supwisdom.dlpay.framework.domain.TSubjectday;
import com.supwisdom.dlpay.framework.domain.TSubjectdayPK;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface SubjectdayDao extends JpaRepository<TSubjectday, TSubjectdayPK> {

  @Query(value = "from TSubjectday where accdate=:accdate ")
  List<TSubjectday> getAllByAccdate(@Param("accdate") String accdate);

  @Query(value = "select a.subjno as shopaccno,a.begindrbal as dramt,a.begincrbal as cramt from TB_SUBJECTDAY a left join (select subjno from TB_SUBJECT where endflag=1) b on a.subjno=b.subjno where a.accdate=:accdate and b.subjno is not null ", nativeQuery = true)
  List<MerchBean> getEndSubjectbalInfos(@Param("accdate") String accdate);

  @Query(value = "from TSubjectday where accdate=:accdate and subjno=:subjno")
  TSubjectday getSubjectDayById(@Param("accdate") String accdate, @Param("subjno") String subjno);

  @Query(value = "from TSubjectday t where t.accdate=:accdate and t.subjno in (select subjno from TSubject where subjlevel=1 and endflag=0 ) ")
  List<TSubjectday> getParentSubjectday(@Param("accdate") String accdate);

  @Query(value = "select sum(sb.begindrbal) as begindrbal,sum(sb.begincrbal) as begincrbal,sum(sb.dramt) as dramt,sum(sb.cramt) as cramt,sum(sb.drbal) as drbal,sum(sb.crbal) as crbal  " +
      "from TB_SUBJECTDAY sb, TB_SUBJECT s " +
      "where sb.accdate =:accdate and sb.subjno=s.subjno and s.subjlevel=2 and s.fsubjno=:fsubjno ",nativeQuery = true)
  FSubjectInfoBean getParentSumInfo(@Param("accdate") String accdate, @Param("fsubjno") String fsubjno);

  @Query(value = "select sum(begindrbal) as begindrbal,sum(begincrbal) as begincrbal,sum(dramt) as dramt,sum(cramt) as cramt,sum(drbal) as drbal,sum(crbal) as crbal " +
      "from tb_subjectday where accdate=:accdate and subjno in (select subjno from tb_subject where subjlevel=1) ", nativeQuery = true)
  FSubjectInfoBean getAllParentSubjectSumInfo(@Param("accdate") String accdate);
}
