package com.supwisdom.dlpay.api

import org.aspectj.lang.JoinPoint
import org.aspectj.lang.annotation.Aspect
import org.aspectj.lang.annotation.Before
import org.aspectj.lang.annotation.Pointcut
import org.springframework.stereotype.Component

@Component
@Aspect
class RestControllerAspect {

    @Pointcut("execution( * com.supwisdom.dlpay.api..*(..))")
    private fun beforeRequest() {
    }

    @Before("beforeRequest()")
    fun check(point: JoinPoint) {
        point.args.forEach {
            println("request : $it")
        }
    }
}
