package com.supwisdom.dlpay.api.domain;

import javax.persistence.*;

/**
 * 积分流水表
 */
@Entity
@Table(name = "TB_POINTS_TRANSDTL",
    indexes = {@Index(name = "points_transdtl_idx", columnList = "billno")})
public class TPointsTransdtl {
  @Id
  @Column(name="REFNO", nullable = false, length = 32)
  private String refno;

  @Column(name="USERID", nullable = false, length = 32)
  private String userid;

  @Column(name="ACCDATE", length = 8)
  private String accdate;

  @Column(name="POINTS", nullable = false, length = 15)
  private Long points;

  @Column(name="BEFPOINTS", length = 15)
  private Long befpoints;

  @Column(name="AFTPOINTS", length = 15)
  private Long aftpoints;

  @Column(name="STATUS", length = 15)
  private String status;

  @Column(name="BILLNO", length = 32)
  private String billno; //关联的消费流水号

  @Column(name="TRANSDATE", length = 8)
  private String transdate;

  @Column(name="TRANSTIME", length = 9)
  private String transtime;

  public TPointsTransdtl() {
  }

  public TPointsTransdtl(String refno, String userid, String accdate, Long points, Long befpoints, Long aftpoints, String status, String billno, String transdate, String transtime) {
    this.refno = refno;
    this.userid = userid;
    this.accdate = accdate;
    this.points = points;
    this.befpoints = befpoints;
    this.aftpoints = aftpoints;
    this.status = status;
    this.billno = billno;
    this.transdate = transdate;
    this.transtime = transtime;
  }

  public String getRefno() {
    return refno;
  }

  public void setRefno(String refno) {
    this.refno = refno;
  }

  public String getUserid() {
    return userid;
  }

  public void setUserid(String userid) {
    this.userid = userid;
  }

  public String getAccdate() {
    return accdate;
  }

  public void setAccdate(String accdate) {
    this.accdate = accdate;
  }

  public Long getPoints() {
    return points;
  }

  public void setPoints(Long points) {
    this.points = points;
  }

  public Long getBefpoints() {
    return befpoints;
  }

  public void setBefpoints(Long befpoints) {
    this.befpoints = befpoints;
  }

  public Long getAftpoints() {
    return aftpoints;
  }

  public void setAftpoints(Long aftpoints) {
    this.aftpoints = aftpoints;
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public String getBillno() {
    return billno;
  }

  public void setBillno(String billno) {
    this.billno = billno;
  }

  public String getTransdate() {
    return transdate;
  }

  public void setTransdate(String transdate) {
    this.transdate = transdate;
  }

  public String getTranstime() {
    return transtime;
  }

  public void setTranstime(String transtime) {
    this.transtime = transtime;
  }
}
