package com.supwisdom.dlpay.framework.domain;

import com.supwisdom.dlpay.framework.util.HmacUtil;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import sun.misc.Cleaner;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;

@Entity
@Table(name = "TB_SHOPACC")
public class TShopacc {
  @Id
  @Column(name = "SHOPACCNO", length = 10)
  private String shopaccno;

  @Column(name = "SHOPID", precision = 9)
  private Integer shopid;

  @Column(name = "SHOPNAME", length = 200)
  private String shopname;

  @Column(name = "SUBJNO", length = 10)
  private String subjno;

  @Column(name = "STATUS", length = 20)
  private String status;

  @Column(name = "OPENDATE", length = 8)
  private String opendate;

  @Column(name = "CLOSEDATE", length = 8)
  private String closedate;

  @Column(name = "BALANCE", length = 15, precision = 2)
  private Double balance = 0.0;

  @Column(name = "VERSION")
  private Long version = 1L;

  @Column(name = "LASTUPDATE")
  private Timestamp lastUpdate = new Timestamp(System.currentTimeMillis());

  @Column(name = "MAC")
  private String mac;

  public String getShopaccno() {
    return shopaccno;
  }

  public void setShopaccno(String shopaccno) {
    this.shopaccno = shopaccno;
  }

  public Integer getShopid() {
    return shopid;
  }

  public void setShopid(Integer shopid) {
    this.shopid = shopid;
  }

  public String getShopname() {
    return shopname;
  }

  public void setShopname(String shopname) {
    this.shopname = shopname;
  }

  public String getSubjno() {
    return subjno;
  }

  public void setSubjno(String subjno) {
    this.subjno = subjno;
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public String getOpendate() {
    return opendate;
  }

  public void setOpendate(String opendate) {
    this.opendate = opendate;
  }

  public String getClosedate() {
    return closedate;
  }

  public void setClosedate(String closedate) {
    this.closedate = closedate;
  }

  public void setBalance(Double balance) {
    this.balance = balance;
  }

  public Double getBalance() {
    return balance;
  }

  public Long getVersion() {
    return this.version;
  }

  public String getMac() {
    return mac;
  }

  public void setMac(String mac) {
    this.mac = mac;
  }

  public void incrOrDecrBalance(Double amount) {
    this.balance += amount;
    this.lastUpdate = new Timestamp(System.currentTimeMillis());
    this.version++;
  }

}
