package com.supwisdom.dlpay.framework.security;

import com.supwisdom.dlpay.framework.domain.*;
import com.supwisdom.dlpay.framework.util.DateUtil;
import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.system.service.FunctionService;
import com.supwisdom.dlpay.system.service.OperatorService;
import com.supwisdom.dlpay.system.service.RoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;

@Component
public class MyPermissionEvaluator implements PermissionEvaluator {
    @Autowired
    private RoleService roleService;
    @Autowired
    private OperatorService operatorService;
    @Autowired
    private FunctionService functionService;
    @Override
    public boolean hasPermission(Authentication authentication, Object targetUri, Object permission) {
        //TODO save logger
        if (targetUri != null) {
            UserDetails userDetails = (UserDetails) authentication.getPrincipal();
            if (userDetails != null) {
                TOperator operator = operatorService.getOperatorByCode(userDetails.getUsername());
                if (operator != null) {
                    List<TOperRole> operRoles = operatorService.getOperRoleByOperId(operator.getOperid());
                    for (TOperRole operRole : operRoles) {
                        TRole role = roleService.findRoleByRoleid(operRole.getRoleId());
                        if (role != null) {
                            TResource resource = roleService.findResourceByURI(String.valueOf(targetUri));
                            if (resource != null) {
                                TPermission permission1 = roleService.findByRoleIdAndResid(role.getRoleId(), resource.getId());
                                if (permission1 != null) {
                                    TOperLog log = new TOperLog();
                                    log.setLogdate(DateUtil.getNow());
                                    log.setOperid(operator.getOperid());
                                    log.setOpername(operator.getOpercode());
                                    log.setResname(resource.getName());
                                    log.setRespath(resource.getUri());
                                    TFunction function  =functionService.getFunctionById(resource.getFunctionId());
                                    if(function!=null){
                                        log.setFunctionid(function.getId());
                                        log.setFunctionname(function.getName());
                                    }
                                    operatorService.saveOperLog(log);
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    @Override
    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, Object permission) {
        return false;
    }
}
