package com.supwisdom.dlpay.framework.service.impl;

import com.supwisdom.dlpay.framework.dao.OperRoleDao;
import com.supwisdom.dlpay.framework.dao.OperatorDao;
import com.supwisdom.dlpay.framework.domain.TOperator;
import com.supwisdom.dlpay.framework.service.OperatorDetailService;
import com.supwisdom.dlpay.framework.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Service
public class OperatorDetailServiceImpl implements OperatorDetailService {
  @Autowired
  private OperatorDao operatorDao;
  @Autowired
  private OperRoleDao operRoleDao;

  @Override
  public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
    TOperator oper = operatorDao.findByOpercode(username);
    if (null == oper) {
      throw new UsernameNotFoundException("管理员不存在");
    }
    Collection<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>() {
    };

    List<String> roles = operRoleDao.getRolecodeByOperid(oper.getOperid());
    if (!StringUtil.isEmpty(roles)) {
      authorities = AuthorityUtils.createAuthorityList(roles.toArray(new String[0]));
    }
    oper.setAuthorities(authorities);
    return oper;
  }
}
