package com.supwisdom.dlpay.system.service;

import com.supwisdom.dlpay.api.domain.TPaytype;
import com.supwisdom.dlpay.framework.domain.TShop;
import com.supwisdom.dlpay.framework.util.PageResult;
import com.supwisdom.dlpay.system.bean.ShopConfigBean;
import com.supwisdom.dlpay.system.bean.ZTreeNode;
import com.supwisdom.dlpay.util.WebCheckException;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

public interface ShopDataService {
  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class,readOnly = true)
  List<ZTreeNode> getAllShopNodes();

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class,readOnly = true)
  TShop getShopByShopid(Integer shopid);

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
  boolean deleteShop(TShop shop) throws WebCheckException;

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
  boolean saveOrUpdateShop(TShop shop) throws WebCheckException;

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class,readOnly = true)
  List<TPaytype> getConsumePaytypes();

  @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class,readOnly = true)
  PageResult<ShopConfigBean> getShopPaytypeInfos(String shopaccno, String paytype, Integer shopid, int pageNo, int pageSize);
}
