package com.supwisdom.dlpay.api

import com.google.gson.Gson
import com.sun.jersey.api.client.Client
import com.sun.jersey.api.client.ClientResponse
import com.supwisdom.dlpay.api.bean.BaseResp
import com.supwisdom.dlpay.api.bean.SupStatusRevResp
import com.supwisdom.dlpay.api.bean.SupYktResp
import com.supwisdom.dlpay.api.bean.WechatReqResp
import com.supwisdom.dlpay.api.domain.TPersondtl
import com.supwisdom.dlpay.api.domain.TShopdtl
import com.supwisdom.dlpay.framework.util.*
import com.supwisdom.dlpay.util.Code

class CallBackResp {
    var retcode: String = "99"
    var retmsg: String? = null
    val data = mutableMapOf<String, String>()
    fun add(key: String, value: String) {
        this.data.plus(mapOf(key to value))
    }
}

class CallService {

    companion object {
        fun callYktPay(config: Map<String, String?>, paydtl: TPersondtl, time: String, stuempno: String, yktshopid: String, devphyid: String?): CallBackResp {
            val code = CallBackResp()
            val appid = config["appid"]
            if (appid.isNullOrEmpty()) {
                code.retcode = "1"
                code.retmsg = "一卡通支付方式未启用或未配置"
                return code
            }

            val appkey = config["appkey"]
            val orderurl = config["orderurl"]

            val params = hashMapOf<String, String?>()
            params.put("partner_id", appid)
            params.put("stuempno", stuempno)
            params.put("tradeno", paydtl.refno)
            params.put("tradename", paydtl.payinfo)
            params.put("amount", MoneyUtil.YuanToFen(paydtl.amount).toString())
            params.put("shopid", yktshopid)
            params.put("devphyid", devphyid)
            params.put("calcmanagefee", "T") //是否计算费率
            params.put("timestamp", time)
            params.put("sign_method", "HMAC");
            params.put("limitflag", "off") //是否判断消费限额，on-判断；off-不判断。默认on（判断限额）。为空或不为off都是on；
            var signstr = StringUtil.createLinkString(HmacUtil.paraFilter(params))
            val sign = HmacUtil.HMACSHA1(signstr, appkey)
            signstr = "$signstr&sign=$sign&sourcetype=food"
            val c = Client.create()
            c.setConnectTimeout(20000)
            val r = c.resource(orderurl)
            val respClient = r.post(ClientResponse::class.java, signstr)
            if (200 == respClient.status) {
                val ret = respClient.getEntity(String::class.java)
                if (ret != null) {
                    try {
                        val gson = Gson()
                        val result = gson.fromJson(ret, SupYktResp::class.java)
                        if (result == null) {
                            code.retcode = "1"
                            code.retmsg = "返回内容为空"
                            return code
                        }
                        if ("0" != result.retcode) {
                            if ("30" == result.retcode) {
                                if (result.other != null) {
                                    try {
                                        val supStatusRevResp = gson.fromJson(result.other,
                                                SupStatusRevResp::class.java)
                                        if (supStatusRevResp != null) {
                                            //同流水号，同一笔已经支付完成的，不重复支付。
                                            if (3 == supStatusRevResp.status
                                                    && supStatusRevResp.revflag != null
                                                    && !supStatusRevResp.revflag) {
                                                code.retcode = "0"
                                                code.retmsg = "成功"
                                                return code
                                            }
                                        }
                                    } catch (e: Exception) {
                                        e.printStackTrace()
                                    }
                                }
                            }
                            code.retcode = "1"
                            code.retmsg = "交易失败:" + result.retmsg
                            return code
                        }
                        code.retcode = "0"
                        code.retmsg = "成功"
                        return code
                    } catch (e: Exception) {
                        e.printStackTrace()
                    }
                }
            }
            code.retcode = "1"
            code.retmsg = "请求失败"
            return code
        }

        fun callWechatPay(config: Map<String, String>, paydtl: TPersondtl, time: String, wechattype: String,
                          realip: String?, qrcode: String?, openid: String?): BaseResp {
            val code = BaseResp()
            val appid = config["appid"]
            if (appid.isNullOrEmpty()) {
                code.retcode = "1"
                code.retmsg = "微信支付方式未启用或未配置"
                return code
            }
            val appkey = config["appkey"]
            val orderurl = config["orderurl"]
            val mchid = config["mchid"]
            val wechatReqResp = WechatReqResp()
            wechatReqResp.openid = openid
            wechatReqResp.appid = appid
            wechatReqResp.total_fee = MoneyUtil.YuanToFen(paydtl.amount)
            wechatReqResp.body = paydtl.payinfo
            wechatReqResp.key = appkey
            wechatReqResp.mch_id = mchid
            wechatReqResp.notify_url = config["notifyurl"] + "/notify/wechat"
            wechatReqResp.out_trade_no = paydtl.refno
            wechatReqResp.spbill_create_ip = realip
            val c = Client.create()
            c.setConnectTimeout(20000)
            return when (wechattype) {
                "qrcode" -> {
                    code
                }
                "app" -> {
                    wechatReqResp.trade_type = "APP"
                    code
                }
                "mp" -> {
                    wechatReqResp.trade_type = "JSAPI"
                    wechatReqResp.generaSign()
                    val xml = wechatReqResp.generaXML()
                    val r = c.resource(orderurl)
                    val respClient = r.post(ClientResponse::class.java, xml)
                    if (200 == respClient.status) {
                        try {
                            val ret = respClient.getEntity(String::class.java)
                            if (ret != null) {
                                val eleMap = XmlUtils.parseXml(ret)
                                val retcode = eleMap["return_code"]
                                val result_code = eleMap["result_code"]
                                val prepay_id = eleMap["prepay_id"]
                                if (!retcode.isNullOrEmpty() && "SUCCESS" == retcode
                                        && !result_code.isNullOrEmpty() && "SUCCESS" == result_code
                                        && !prepay_id.isNullOrEmpty()) {
                                    wechatReqResp.retcode = 0
                                    wechatReqResp.retmsg = "初始化成功"
                                    wechatReqResp.prepay_id = prepay_id
                                    //TODO prepay_id 是否保存
                                    wechatReqResp.timestamp = DateUtil.getNowSecond().toString()
                                    wechatReqResp.nonce_str = RandomUtils.getRandomString(30)
                                    wechatReqResp.generaJSAPISign()
                                    val params = wechatReqResp.generaJSAPIParamters()
                                    code.setCode(Code.SUCCESS)
                                    code.data = params
                                } else {
                                    code.retcode = "1"
                                    code.retmsg = eleMap["return_msg"]
                                }
                            } else {
                                code.retcode = "1"
                                code.retmsg = "微信支付请求失败"
                            }
                        } catch (e: Exception) {
                            e.printStackTrace()
                            code.retcode = "1"
                            code.retmsg = "微信支付请求异常"
                        }

                    } else {
                        code.retcode = "1"
                        code.retmsg = "微信支付请求返回失败"
                    }
                    code
                }
                "h5" -> {
                    wechatReqResp.trade_type = "MWEB"
                    wechatReqResp.scene_info = "{\"h5_info\": {\"type\":\"Wap\",\"wap_url\": \"" + config["notifyurl"] + "\",\"wap_name\": \"${paydtl.payinfo}\"}}"
                    val xml = wechatReqResp.generaXML()
                    val r = c.resource(orderurl)
                    val respClient = r.post(ClientResponse::class.java, xml)
                    if (200 == respClient.status) {
                        try {
                            val ret = respClient.getEntity(String::class.java)
                            if (ret != null) {
                                val eleMap = XmlUtils.parseXml(ret)
                                val retcode = eleMap["return_code"]
                                val result_code = eleMap["result_code"]
                                val prepay_id = eleMap["prepay_id"]
                                val mweb_url = eleMap["mweb_url"]
                                if (!retcode.isNullOrEmpty() && "SUCCESS" == retcode
                                        && !result_code.isNullOrEmpty() && "SUCCESS" == result_code
                                        && !prepay_id.isNullOrEmpty()) {
                                    wechatReqResp.retcode = 0
                                    wechatReqResp.retmsg = "初始化成功"
                                    wechatReqResp.prepay_id = prepay_id
                                    wechatReqResp.mweb_url = mweb_url
                                    code.setCode(Code.SUCCESS)
                                    code.data = mweb_url
                                } else {
                                    code.retcode = "1"
                                    code.retmsg = eleMap["return_msg"]
                                }
                            } else {
                                code.retcode = "1"
                                code.retmsg = "微信支付请求失败"
                            }
                        } catch (e: Exception) {
                            e.printStackTrace()
                            code.retcode = "1"
                            code.retmsg = "微信支付请求异常"
                        }

                    } else {
                        code.retcode = "1"
                        code.retmsg = "微信支付请求返回失败"
                    }
                    code
                }
                else -> {
                    code.retcode = "1"
                    code.retmsg = "未标识的类型：wechattype=$wechattype"
                    code
                }
            }
        }

        fun CallCitizenCardPay(config: Map<String, String?>, paydtl: TShopdtl): CallBackResp {
            val resp = CallBackResp()
            resp.retcode = "0"
            // TODO: 代扣逻辑
            return resp
        }
    }
}