package com.supwisdom.dlpay.api.service

import com.supwisdom.dlpay.api.domain.TAccount
import com.supwisdom.dlpay.framework.domain.TFeetypeConfig
import com.supwisdom.dlpay.framework.domain.TShopacc
import com.supwisdom.dlpay.framework.domain.TSubject
import org.springframework.transaction.annotation.Propagation
import org.springframework.transaction.annotation.Transactional

interface AccountUtilServcie {

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class))
    fun readAccountForUpdateNowait(userid: String): TAccount


    fun readAccount(userid: String): TAccount

    fun readShopAcc(shopId: Int): TShopacc

    fun readShopbyShopaccno(shopaccno: String): TShopacc

    fun readSubject(subjno: String): TSubject

    fun readFeetype(feetype: String, paytype: String): TFeetypeConfig
}
