package com.supwisdom.dlpay.api.service

import com.supwisdom.dlpay.api.TransactionBuilder
import com.supwisdom.dlpay.api.domain.TAccount
import com.supwisdom.dlpay.api.domain.TTransactionMain
import org.springframework.transaction.annotation.Propagation
import org.springframework.transaction.annotation.Transactional

interface TransactionService {
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = [Exception::class])
    fun init(builder: TransactionBuilder): TTransactionMain

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = [Exception::class])
    fun wip(refno: String): TTransactionMain

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = [Exception::class])
    fun wip(builder: TransactionBuilder): TTransactionMain

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = [Exception::class])
    fun fail(refno: String): TTransactionMain

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = [Exception::class])
    fun fail(refno: String, remark: String): TTransactionMain

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = [Exception::class])
    fun success(refno: String): TTransactionMain

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = [Exception::class])
    fun success(refno: String, remark: String): TTransactionMain
}

interface PersonAccountService {
    fun recalcBalance(account: TAccount, amount: Double)
}