package com.supwisdom.dlpay.framework.dao;

import com.supwisdom.dlpay.framework.domain.TFunction;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface FunctionDao extends JpaRepository<TFunction, Integer> {
    @Query("select distinct t from TFunction t,TRoleFunction a, TOperRole b where t.id=a.functionId and a.roleId=b.roleId and b.operid=?1 order by t.orderNum ")
    List<TFunction> getTFunctionsByOperid(String operid);

    Page<TFunction> findAllByNameContaining(String name, Pageable pageable);

    TFunction findByName(String name);

    TFunction findByNameAndIdNot(String name, Integer id);

    List<TFunction> findByParentId(Integer parentId);

    List<TFunction> findByIsLeaf(Integer isLeaf);
}
