package com.supwisdom.dlpay.ncmgr.dao.impl;

import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.ncmgr.dao.NcDevWeekDao;
import com.supwisdom.dlpay.ncmgr.domain.TNcDevweek;
import com.supwisdom.dlpay.system.page.Pagination;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import java.util.List;

@Repository
public class NcDevWeekDaoImpl implements NcDevWeekDao {
    @PersistenceContext
    EntityManager entityManager;

    @Transactional
    @Override
    public boolean updListVersion() {
        boolean flag=false;
        try {
            String sql = "update T_NC_DEVWEEK set version=version+1";
            Query query = entityManager.createNativeQuery(sql);
            query.executeUpdate();
            flag=true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public Pagination getNcDevWeekWithPage(int weekid, String devname, int pageNo, int pageSize) {
        String sql = " select bean from TNcDevweek bean where 1>0 ";
        if (!StringUtil.isEmpty(devname)) {
            sql += " and bean.devname like :devname ";
        }
        if (weekid!=0) {
            sql+=" and bean.id.weekid=:wid ";
        }
        TypedQuery<TNcDevweek> query = entityManager.createQuery(sql, TNcDevweek.class);
        if (!StringUtil.isEmpty(devname)) {
            query.setParameter("devname", "%"+devname+"%");
        }
        if (weekid!=0) {
            query.setParameter("wid", weekid);
        }
        List<TNcDevweek> list = query.getResultList();
        pageNo = pageNo <= 0 ? 1 : pageNo;
        query.setFirstResult((pageNo - 1) * pageSize);
        query.setMaxResults(pageSize);
        Pagination page = new Pagination();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        page.setList(list);
        int totalCount = list.size();
        page.setTotalCount(totalCount);
        return page;
    }

    @Transactional
    @Override
    public void delDevWeekById(int devid, int weekid) {
        try {
            String sql = "delete from T_NC_DEVWEEK where devid=?1 and weekid=?2";
            Query query = entityManager.createNativeQuery(sql);
            query.setParameter(1, devid);
            query.setParameter(2, weekid);
            query.executeUpdate();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Transactional
    @Override
    public int findMaxDevWeekVersion() {
        try{
            String sql = "select max(r.version) from TNcDevweek r";
            Query query = entityManager.createQuery(sql);
            Object result = query.getSingleResult();
            if (result == null){
                return 0;
            }else{
                return  (int)result;
            }
        }catch(Exception e){
            e.printStackTrace();
        }
        return 0;
    }

    @Transactional
    @Override
    public void deleteDevWeekByWeekId(int weekId) {
        String sql="delete from T_NC_DEVWEEK where weekid=?1";
        Query query = entityManager.createNativeQuery(sql);
        query.setParameter(1,weekId);
        query.executeUpdate();
    }

    @Transactional
    @Override
    public boolean saveDevWeek(TNcDevweek devweek) {
        boolean flag=false;
        try {
            entityManager.persist(devweek);
            flag=true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public List<TNcDevweek> findChosenDev(int weekId) {
        String sql="select r  from TNcDevweek r where r.id.weekid=:id";
        TypedQuery<TNcDevweek> query = entityManager.createQuery(sql, TNcDevweek.class);
        query.setParameter("id", weekId);
        List<TNcDevweek> list = query.getResultList();
        return list;
    }
}
