package com.supwisdom.dlpay.ncmgr.dao.impl;

import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.ncmgr.dao.NcTimeDao;
import com.supwisdom.dlpay.ncmgr.domain.TNcTime;
import com.supwisdom.dlpay.system.page.Pagination;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import java.util.List;

@Repository
public class NcTimeDaoImpl implements NcTimeDao {
    @PersistenceContext
    EntityManager entityManager;

    @Transactional
    @Override
    public Pagination getNcTimeWithPage(String timename, int pageNo, int pageSize) {
        String sql = " select bean from TNcTime bean where 1>0 ";
        if (!timename.equals("")) {
            sql+=" and bean.timename like :timename ";
        }
        TypedQuery<TNcTime> query = entityManager.createQuery(sql, TNcTime.class);
        if (!timename.equals("")){
            query.setParameter("timename", "%"+timename+"%");
        }
        List<TNcTime> list = query.getResultList();
        pageNo = pageNo <= 0 ? 1 : pageNo;
        query.setFirstResult((pageNo - 1) * pageSize);
        query.setMaxResults(pageSize);
        Pagination page = new Pagination();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        page.setList(list);
        int totalCount = list.size();
        page.setTotalCount(totalCount);
        return page;

    }

    @Transactional
    @Override
    public List<String> getTimegrpIdById(int id) {
        String sql = "select timegrpid from t_nc_timegrp where " +
                " timeid1=?1 or timeid2=?2 or timeid3=?3 or timeid4=?4 " +
                " or timeid5=?5 or timeid6=?6 ";
        Query query = entityManager.createNativeQuery(sql);
        query.setParameter(1, id);
        query.setParameter(2, id);
        query.setParameter(3, id);
        query.setParameter(4, id);
        query.setParameter(5, id);
        query.setParameter(6, id);
        List<String> list = query.getResultList();

        return list;
    }

    @Transactional
    @Override
    public boolean delTimeByTimeId(int id) {
        boolean flag = false;
        try {
            String sql = "delete from TNcTime t where t.timeid=?1";
            Query query = entityManager.createQuery(sql);
            query.setParameter(1, id);
            query.executeUpdate();
            flag=true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public TNcTime findByTimeId(int id) {
        String sql = "select r from TNcTime r where r.timeid=:id";
        TypedQuery<TNcTime> query = entityManager.createQuery(sql, TNcTime.class);
        query.setParameter("id", id);
        List<TNcTime> list = query.getResultList();
        if (list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public TNcTime findByTimeName(String name) {
        String sql = "select r from TNcTime r where r.timename=:timename";
        TypedQuery<TNcTime> query = entityManager.createQuery(sql, TNcTime.class);
        query.setParameter("timename", name);
        List<TNcTime> list = query.getResultList();
        if (list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public int getMaxTimeId() {
        String sql = " select Max(timeid) from t_nc_time";
        Query query = entityManager.createNativeQuery(sql);
        Object result = query.getSingleResult();
        if (result!=null){
            return (int)result;
        }
        return 0;
    }

    @Transactional
    @Override
    public boolean saveTime(TNcTime bean) {
        boolean flag=false;
        try {
            entityManager.persist(bean);
            flag=true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public TNcTime findByIdAndName(int id, String name) {
        String sql = "select bean from TNcTime bean where bean.timename=?1 ";
        if (id!=0) {
            sql += " and bean.timeid<>:timeid ";
        }
        TypedQuery<TNcTime> query = entityManager.createQuery(sql, TNcTime.class);
        query.setParameter(1, name);
        if (id!=0) {
            query.setParameter("timeid", id);
        }
        List<TNcTime> list = query.getResultList();
        if (list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public boolean updateTime(TNcTime bean) {
        boolean flag = false;
        try {
            entityManager.merge(bean);
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public List<TNcTime> findAllNcTime() {
        String sql = " select r from TNcTime r order by r.timeid";
        TypedQuery<TNcTime> query = entityManager.createQuery(sql, TNcTime.class);
        List<TNcTime> list = query.getResultList();
        return list;
    }
}
