package com.supwisdom.dlpay.ncmgr.dao.impl;

import com.supwisdom.dlpay.framework.util.StringUtil;
import com.supwisdom.dlpay.ncmgr.dao.NcTimeGrpDao;
import com.supwisdom.dlpay.ncmgr.domain.TNcTimegrp;
import com.supwisdom.dlpay.system.page.Pagination;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import java.util.List;

@Repository
public class NcTimeGrpDaoImpl implements NcTimeGrpDao {
    @PersistenceContext
    EntityManager entityManager;

    @Transactional
    @Override
    public Pagination getNcTimeGrpWithPage(String timename, int pageNo, int pageSize) {
        String sql = "select bean from TNcTimegrp bean where 1>0 ";
        if (!timename.isEmpty()){
            sql+= " and bean.timegrpname like :timename ";
        }
        TypedQuery<TNcTimegrp> query = entityManager.createQuery(sql, TNcTimegrp.class);
        if (!timename.isEmpty()){
            query.setParameter("timename", "%"+timename+"%");
        }
        List<TNcTimegrp> list = query.getResultList();
        pageNo = pageNo <= 0 ? 1 : pageNo;
        query.setFirstResult((pageNo - 1) * pageSize);
        query.setMaxResults(pageSize);
        Pagination page = new Pagination();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        page.setList(list);
        int totalCount = list.size();
        page.setTotalCount(totalCount);
        return page;
    }

    @Transactional
    @Override
    public TNcTimegrp findByTimeGrpId(int id) {
        String sql = "select r from TNcTimegrp r where r.timegrpid=:id";
        TypedQuery<TNcTimegrp> query = entityManager.createQuery(sql, TNcTimegrp.class);
        query.setParameter("id", id);
        List<TNcTimegrp> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public TNcTimegrp findByTimeGrpName(String name) {
        String sql = " select r from TNcTimegrp r where r.timegrpname=:name";
        TypedQuery<TNcTimegrp> query = entityManager.createQuery(sql, TNcTimegrp.class);
        query.setParameter("name", name);
        List<TNcTimegrp> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public int getMaxTimeGrpId() {
        String sql = "select Max(timegrpid) from t_nc_timegrp";
        Query query = entityManager.createNativeQuery(sql);
        Object result = query.getSingleResult();
        if (result!=null){
            return (int)result;
        }
        return 0;
    }

    @Transactional
    @Override
    public boolean saveTimegrp(TNcTimegrp bean) {
        boolean flag=false;
        try {
            entityManager.persist(bean);
            flag=true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public TNcTimegrp findByGrpIdAndName(int id, String name) {
        String sql = "select bean from TNcTimegrp bean where bean.timegrpname=?1 ";
        if (!StringUtil.isEmpty(name)) {
            sql += " and bean.timegrpid<>:timeid ";
        }
        TypedQuery<TNcTimegrp> query = entityManager.createQuery(sql, TNcTimegrp.class);
        query.setParameter(1, name);
        if (id!=0){
            query.setParameter("timeid", id);
        }
        List<TNcTimegrp> list = query.getResultList();
        if (list!=null && list.size()>0){
            return list.get(0);
        }
        return null;
    }

    @Transactional
    @Override
    public boolean updateTimegrp(TNcTimegrp bean) {
        boolean flag = false;
        try {
            entityManager.merge(bean);
            flag = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    @Transactional
    @Override
    public List<String> getWeekTimeById(int id) {
        try{
            String sql = "select t.weekid from TNcWeektime t where (t.day1grpid=:id or t.day2grpid=:id " +
                    " or t.day3grpid=:id or t.day4grpid=:id or t.day5grpid=:id or t.day6grpid=:id " +
                    " or t.day7grpid=:id) and t.adddelflag='1'";
            Query query = entityManager.createQuery(sql);
            query.setParameter("id",id);
            List list = query.getResultList();
            return list;
        }catch (Exception e){
            e.printStackTrace();
        }
        return null;
    }

    @Transactional
    @Override
    public boolean delByGrpId(int id) {
        boolean flag = false;
        try {
            String sql = "delete from TNcTimegrp t where t.timegrpid=?1";
            Query query = entityManager.createQuery(sql);
            query.setParameter(1, id);
            query.executeUpdate();
            flag=true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return flag;
    }

    @Override
    public List<TNcTimegrp> findAllNcTimeGrp() {
        String sql = " select r from TNcTimegrp r order by r.timegrpid";
        TypedQuery<TNcTimegrp> query = entityManager.createQuery(sql, TNcTimegrp.class);
        return query.getResultList();
    }
}
