package com.supwisdom.dlpay.ncmgr.service;

import com.supwisdom.dlpay.ncmgr.domain.*;
import com.supwisdom.dlpay.system.page.Pagination;

import java.util.List;
import java.util.Map;

public interface NcService {
    //根据查询条件分页获取所有设备
    public Pagination getNcDeviceWithPage(String devname, int pageNo, int pageSize, Map map, String buildingid, String devtype);

    //获取所有楼栋信息
    public List<TBuilding> getAllBuilding();

    //根据楼栋id获取楼栋信息
    public TBuilding getBuidingById(String id);

    //根据设备类型获取所有设备
    public List<TNcDevice> getDevByType(String type);

    //根据设备id获取设备
    public TNcDevice findDevById(int id);

    //验证设备名称
    public TNcDevice validDevName(int devid,String devname);

    //验证设备物理编号
    public TNcDevice validDevPhyid(int devid,String devPhyid);

    //验证读头号
    public TNcDevice validDevNo(int fdevid,int devno,int devid);

    //修改设备
    public boolean updateDevice(TNcDevice bean);

    //获取设备最大主键
    public int getMaxId();

    //保存设备
    public boolean saveDevice(TNcDevice bean);

    //根据设备编号获取设备及父设备信息
    public TNcDevice getDevInfoByDevid(int devid);

    //根据设备编号删除设备
    public void delDevById(int devid);

    //设备名单清空(获取清空所用名单)
    public TNcCardlist getCleanList(String devid);

    //保存同步名单信息
    public boolean saveCardlist(TNcCardlist bean);

    //设备名单重下(修改该设备已同步名单为未同步)
    public void updateForListReload(String devid);

    //根据查询条件分页获取所有时间段信息
    public Pagination getNcTimeWithPage(String time,int pageNo, int pageSize,Map map);

    //根据时间段
    public List<String> getTimegrpIdById(int id);

    //根据时间段id删除时间段
    public boolean delTimeByTimeId(int id);

    //DevWeek数据所有版本号+1
    public boolean updListVersion();

    //根据时间段id获取时间段信息
    public TNcTime findByTimeId(int id);

    //根据时间段名称获取时间段信息
    public TNcTime findByTimeName(String name);

    //获取时间段最大主键
    public int getMaxTimeId();

    //保存时间段
    public boolean saveTime(TNcTime bean);

    //根据id和名称获取时间段信息
    public TNcTime findByIdAndName(int id, String name);

    //修改时间段
    public boolean updateTime(TNcTime bean);

    //根据查询条件分页获取时间组
    public Pagination getNcTimeGrpWithPage(String time,int pageNo, int pageSize,Map map);

    //获取所有时间段
    public List<TNcTime> findAllNcTime();

    //根据id获取时间组信息
    public TNcTimegrp findByTimeGrpId(int id);

    //根据时间组名称获取时间组信息
    public TNcTimegrp findByTimeGrpName(String name);

    //获取时间组最大id主键
    public int getMaxTimeGrpId();

    //保存时间组
    public boolean saveTimegrp(TNcTimegrp bean);

    //根据id和名称查询时间组是否存在
    public TNcTimegrp findByGrpIdAndName(int id,String name);

    //修改时间组
    public boolean updateTimegrp(TNcTimegrp bean);

    //根据时间组id查询此时间组是否被时间周使用
    public List<String> getWeekTimeById(int id);

    //根据id删除时间组
    public boolean delByGrpId(int id);

    //根据查询条件分页获取时间周
    public Pagination getNcWeekTimeWithPage(String time,int pageNo, int pageSize,Map map);

    //获取所有时间组
    public List<TNcTimegrp> findAllNcTimeGrp();

    //根据id获取时间周信息
    public TNcWeektime findByWeekTimeId(int id);

    //根据名称获取时间周信息
    public TNcWeektime findByWeekTimeName(String name);

    //获取最大时间周id 只支持3-15
    public int getMaxWeekId();

    //保存时间周
    public boolean saveWeektime(TNcWeektime bean);

    //根据id和名称查询时间周是否存在
    public TNcWeektime findByWeekIdAndName(int id,String name);

    //修改时间周
    public boolean updateWeektime(TNcWeektime bean);

    //根据时间周id查询设备绑定时间周情况
    public List getDevWeekByWeekid(int id);

    //根据id删除时间周
    public boolean delByWeekId(int id);

    //根据查询条件分页获取设备绑定时间周信息
    public Pagination getNcDevWeekWithPage(int weekid,String devname,int pageNo, int pageSize,Map map);

    //获取所有时间周
    public List<TNcWeektime> findAllNcWeekTime();

    //根据设备编号和时间周id删除对应设备时间周
    public void delDevWeekById(int devid,int weekid);

    //获取最大设备时间周版本
    public int findMaxDevWeekVersion();

    //根据时间周id删除设备绑定的时间周
    public void deleteDevWeekByWeekId(int weekId);

    //保存设备时间周
    public boolean saveDevWeek(TNcDevweek devweek);

    //根据id查询已选取此时间周的设备
    public List<TNcDevweek> findChosenDev(int weekId);

    //获取所有设备
    public List<TNcDevice> findAllNcDevices();
}
