package com.supwisdom.dlpay.ncmgr.service.impl;

import com.supwisdom.dlpay.ncmgr.dao.*;
import com.supwisdom.dlpay.ncmgr.domain.*;
import com.supwisdom.dlpay.ncmgr.service.NcService;
import com.supwisdom.dlpay.system.page.Pagination;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Service
public class NcServiceImpl implements NcService {
    @Autowired
    private NcDeviceDao ncDeviceDao;
    @Autowired
    private NcCardListDao ncCardListDao;
    @Autowired
    private NcTimeDao ncTimeDao;
    @Autowired
    private NcDevWeekDao ncDevWeekDao;
    @Autowired
    private NcTimeGrpDao ncTimeGrpDao;
    @Autowired
    private NcWeekTimeDao ncWeekTimeDao;


    @Override
    public Pagination getNcDeviceWithPage(String devname, int pageNo, int pageSize, Map map, String buildingid, String devtype) {
        Pagination page = ncDeviceDao.getNcDeviceWithPage(devname, pageNo, pageSize, buildingid, devtype);
        map.put("devPage", page);
        return page;
    }

    @Override
    public List<TBuilding> getAllBuilding() {
        return ncDeviceDao.getAllBuilding();
    }

    @Override
    public TBuilding getBuidingById(String id) {
        return ncDeviceDao.getBuidingById(id);
    }

    @Override
    public List<TNcDevice> getDevByType(String type) {
        return ncDeviceDao.getDevByType(type);
    }

    @Override
    public TNcDevice findDevById(int id) {
        return ncDeviceDao.findDevById(id);
    }

    @Override
    public TNcDevice validDevName(int devid, String devname) {
        return ncDeviceDao.validDevName(devid, devname);
    }

    @Override
    public TNcDevice validDevPhyid(int devid, String devPhyid) {
        return ncDeviceDao.validDevPhyid(devid, devPhyid);
    }

    @Override
    public TNcDevice validDevNo(int fdevid, int devno, int devid) {
        return ncDeviceDao.validDevNo(fdevid, devno, devid);
    }

    @Override
    public boolean updateDevice(TNcDevice bean) {
        return ncDeviceDao.updateDevice(bean);
    }

    @Override
    public int getMaxId() {
        return ncDeviceDao.getMaxId();
    }

    @Override
    public boolean saveDevice(TNcDevice bean) {
        return ncDeviceDao.saveDevice(bean);
    }

    @Override
    public TNcDevice getDevInfoByDevid(int devid) {
        return ncDeviceDao.getDevInfoByDevid(devid);
    }

    @Override
    public void delDevById(int devid) {
        ncDeviceDao.delDevById(devid);
    }

    @Override
    public TNcCardlist getCleanList(String devid) {
        return ncCardListDao.getCleanList(devid);
    }

    @Override
    public boolean saveCardlist(TNcCardlist bean) {
        return ncCardListDao.saveCardlist(bean);
    }

    @Override
    public void updateForListReload(String devid) {

    }

    @Override
    public Pagination getNcTimeWithPage(String time, int pageNo, int pageSize,Map map) {
        Pagination page = ncTimeDao.getNcTimeWithPage(time, pageNo, pageSize);
        map.put("timePage", page);
        return page;
    }

    @Override
    public List<String> getTimegrpIdById(int id) {
        return ncTimeDao.getTimegrpIdById(id);
    }

    @Override
    public boolean delTimeByTimeId(int id) {
        return ncTimeDao.delTimeByTimeId(id);
    }

    @Override
    public boolean updListVersion() {
        return ncDevWeekDao.updListVersion();
    }

    @Override
    public TNcTime findByTimeId(int id) {
        return ncTimeDao.findByTimeId(id);
    }

    @Override
    public TNcTime findByTimeName(String name) {
        return ncTimeDao.findByTimeName(name);
    }

    @Override
    public int getMaxTimeId() {
        return ncTimeDao.getMaxTimeId();
    }

    @Override
    public boolean saveTime(TNcTime bean) {
        return ncTimeDao.saveTime(bean);
    }

    @Override
    public TNcTime findByIdAndName(int id, String name) {
        return ncTimeDao.findByIdAndName(id, name);
    }

    @Override
    public boolean updateTime(TNcTime bean) {
        return ncTimeDao.updateTime(bean);
    }

    @Override
    public Pagination getNcTimeGrpWithPage(String time, int pageNo, int pageSize, Map map) {
        Pagination page = ncTimeGrpDao.getNcTimeGrpWithPage(time, pageNo, pageSize);
        map.put("timeGrpPage", page);
        return page;
    }

    @Override
    public List<TNcTime> findAllNcTime() {
        return ncTimeDao.findAllNcTime();
    }

    @Override
    public TNcTimegrp findByTimeGrpId(int id) {
        return ncTimeGrpDao.findByTimeGrpId(id);
    }

    @Override
    public TNcTimegrp findByTimeGrpName(String name) {
        return ncTimeGrpDao.findByTimeGrpName(name);
    }

    @Override
    public int getMaxTimeGrpId() {
        return ncTimeGrpDao.getMaxTimeGrpId();
    }

    @Override
    public boolean saveTimegrp(TNcTimegrp bean) {
        return ncTimeGrpDao.saveTimegrp(bean);
    }

    @Override
    public TNcTimegrp findByGrpIdAndName(int id, String name) {
        return ncTimeGrpDao.findByGrpIdAndName(id, name);
    }

    @Override
    public boolean updateTimegrp(TNcTimegrp bean) {
        return ncTimeGrpDao.updateTimegrp(bean);
    }

    @Override
    public List<String> getWeekTimeById(int id) {
        return ncTimeGrpDao.getWeekTimeById(id);
    }

    @Override
    public boolean delByGrpId(int id) {
        return ncTimeGrpDao.delByGrpId(id);
    }

    @Override
    public Pagination getNcWeekTimeWithPage(String time, int pageNo, int pageSize, Map map) {
        Pagination page = ncWeekTimeDao.getNcWeekTimeWithPage(time, pageNo, pageSize);
        map.put("weekTimePage", page);
        return page;
    }

    @Override
    public List<TNcTimegrp> findAllNcTimeGrp() {
        return ncTimeGrpDao.findAllNcTimeGrp();
    }

    @Override
    public TNcWeektime findByWeekTimeId(int id) {
        return ncWeekTimeDao.findByWeekTimeId(id);
    }

    @Override
    public TNcWeektime findByWeekTimeName(String name) {
        return ncWeekTimeDao.findByWeekTimeName(name);
    }

    @Override
    public int getMaxWeekId() {
        return ncWeekTimeDao.getMaxWeekId();
    }

    @Override
    public boolean saveWeektime(TNcWeektime bean) {
        return ncWeekTimeDao.saveWeektime(bean);
    }

    @Override
    public TNcWeektime findByWeekIdAndName(int id, String name) {
        return ncWeekTimeDao.findByWeekIdAndName(id, name);
    }

    @Override
    public boolean updateWeektime(TNcWeektime bean) {
        return ncWeekTimeDao.updateWeektime(bean);
    }

    @Override
    public List getDevWeekByWeekid(int id) {
        return ncWeekTimeDao.getDevWeekByWeekid(id);
    }

    @Override
    public boolean delByWeekId(int id) {
        return ncWeekTimeDao.delByWeekId(id);
    }

    @Override
    public Pagination getNcDevWeekWithPage(int weekid, String devname, int pageNo, int pageSize, Map map) {
        Pagination page = ncDevWeekDao.getNcDevWeekWithPage(weekid, devname, pageNo, pageSize);
        map.put("devWeekPage", page);
        return page;
    }

    @Override
    public List<TNcWeektime> findAllNcWeekTime() {
        return ncWeekTimeDao.findAllNcWeekTime();
    }

    @Override
    public void delDevWeekById(int devid, int weekid) {
        ncDevWeekDao.delDevWeekById(devid, weekid);
    }

    @Override
    public int findMaxDevWeekVersion() {
        return ncDevWeekDao.findMaxDevWeekVersion();
    }

    @Override
    public void deleteDevWeekByWeekId(int weekId) {
        ncDevWeekDao.deleteDevWeekByWeekId(weekId);
    }

    @Override
    public boolean saveDevWeek(TNcDevweek devweek) {
        return ncDevWeekDao.saveDevWeek(devweek);
    }

    @Override
    public List<TNcDevweek> findChosenDev(int weekId) {
        return ncDevWeekDao.findChosenDev(weekId);
    }

    @Override
    public List<TNcDevice> findAllNcDevices() {
        return ncDeviceDao.findAllNcDevices();
    }
}
