package com.supwisdom.dlpay.system.controller;

import com.supwisdom.dlpay.system.domain.DictionaryType;
import com.supwisdom.dlpay.system.domain.TDictionaryId;
import com.supwisdom.dlpay.system.page.Pagination;
import com.supwisdom.dlpay.system.service.SystemService;
import com.supwisdom.dlpay.util.RedisUtil;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("/system")
public class SystemController {
    protected static Logger logger = Logger.getLogger(SystemController.class);

    @Autowired
    private SystemService systemService;

    @RequestMapping("/dictionary")
    public String dictionary(ModelMap model){
        return "system/dictionary";
    }

    @RequestMapping("/queue")
    public String queue(ModelMap model){
        return "system/queue";
    }

    /**
     * 获取字典列表
     * @param dicttype
     * @param dictcaption
     * @param pageNo
     * @param pageSize
     * @param request
     * @return
     */
    @RequestMapping(value = "/getDictionary")
    @ResponseBody
    public Map getDictionary(@RequestParam(value = "dicttype", defaultValue = "all") String dicttype,
                             @RequestParam(value = "dictcaption", defaultValue = "") String dictcaption,
                             @RequestParam(value = "pageNo", required = false, defaultValue = "1") int pageNo,
                             @RequestParam(value = "pageSize", required = false, defaultValue = "10") int pageSize,
                             HttpServletRequest request) {
        Map map = new HashMap();
        try {
            Pagination page = new Pagination();
            page = systemService.findDictionary(dicttype, dictcaption, pageNo, pageSize);

            map.put("pageResult", page);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    /**
     * 获取所有字典类型
     * @return
     */
    @RequestMapping(value = "/getDictionaryType")
    @ResponseBody
    public Map getDictionaryType(){
        Map map = new HashMap();
        try {
            List<DictionaryType> type = systemService.findDictionaryType();
            map.put("DictId", type);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    /**
     * 保存字典值
     * @param dicttype
     * @param dicttypename
     * @param dictval
     * @param dictcaption
     * @param request
     * @return
     */
    @RequestMapping(value = "/saveDictionary")
    @ResponseBody
    public Map saveDictionary(@RequestParam(value = "dicttype", required = true) String dicttype,
                                   @RequestParam(value = "dicttypename", defaultValue="") String dicttypename,
                                   @RequestParam(value = "dictval", required = true) String dictval,
                                   @RequestParam(value = "dictcaption", defaultValue="") String dictcaption,
                                   HttpServletRequest request){
        Map map = new HashMap<>();
        try {
            List<TDictionaryId> tDictionaryByType = systemService.findTDictionaryByType(Integer.valueOf(dicttype));
            for (TDictionaryId tDictionaryId : tDictionaryByType) {
                if(tDictionaryId.getDictval().equals(dictval)){
                    map.put("errStr", "数据字典值已存在，保存失败！");
                    return map;
                }
            }
            systemService.saveDictionary(dicttype,dicttypename,dictval,dictcaption);
            RedisUtil.lrem("dict_"+dicttype,0,dictval+"_"+dictcaption);
            RedisUtil.rpush("dict_"+dicttype,dictval+"_"+dictcaption);
            if (Integer.valueOf(dicttype)==17){
                RedisUtil.set("dict_dbcheck",dictval);
            }
            map.put("errStr", "");
        } catch (Exception e) {
            e.printStackTrace();
            map.put("errStr", "保存字典失败");
            logger.error("保存字典失败：" + e.getMessage());
        }
        return map;
    }

    /**
     * 更新字典值
     * @param dicttype
     * @param dicttypename
     * @param dictval
     * @param dictcaption
     * @param oriengaltype
     * @param oriengalval
     * @param request
     * @return
     */
    @RequestMapping(value = "/updateDictionary")
    @ResponseBody
    public Map updateDictionary(
            @RequestParam(value = "dicttype", required = true) String dicttype,
            @RequestParam(value = "dicttypename", defaultValue="") String dicttypename,
            @RequestParam(value = "dictval", required = true) String dictval,
            @RequestParam(value = "dictcaption", defaultValue="") String dictcaption,
            @RequestParam(value = "oriengaltype", required = true) String oriengaltype,
            @RequestParam(value = "oriengalval", required = true) String oriengalval,
            HttpServletRequest request) {
        Map map = new HashMap<>();
        try {
            List<TDictionaryId> byType1 = systemService.findByType(Integer.valueOf(oriengaltype), dictval);
            boolean flag = false;
            for (TDictionaryId tDictionaryId : byType1) {
                String dicttype1 = tDictionaryId.getDicttype().toString();
                String dictval1 = tDictionaryId.getDictval();
                String dictcaption1 = tDictionaryId.getDictcaption();
                if(dicttype1.equals(dicttype)&&dictval1.equals(dictval)&&dictcaption1.equals(dictcaption)){
                    flag=true;
                }
            }
            if(flag){
                map.put("errStr", "字典值重复，修改失败！");
                return map;
            }
            List<TDictionaryId> byType = systemService.findByType(Integer.valueOf(oriengaltype), oriengalval);
            systemService.updateDictionary(dicttype,dicttypename,dictval,dictcaption, oriengaltype, oriengalval);
            for (TDictionaryId tDictionaryId : byType) {
                RedisUtil.lrem("dict_"+tDictionaryId.getDicttype(),0,tDictionaryId.getDictval()+"_"+tDictionaryId.getDictcaption());
            }
            RedisUtil.rpush("dict_"+dicttype,dictval+"_"+dictcaption);

            if (Integer.valueOf(dicttype)==17){
                RedisUtil.set("dict_dbcheck",dictval);
            }
            map.put("errStr", "");
        } catch (Exception e) {
            e.printStackTrace();
            map.put("errStr", "修改字典失败");
            logger.error("修改字典失败：" + e.getMessage());
        }
        return map;
    }
}
