package com.supwisdom.dlpay.system.service.impl;

import com.supwisdom.dlpay.system.dao.DictionaryDao;
import com.supwisdom.dlpay.system.domain.DictionaryType;
import com.supwisdom.dlpay.system.domain.TDictionary;
import com.supwisdom.dlpay.system.domain.TDictionaryId;
import com.supwisdom.dlpay.system.page.Pagination;
import com.supwisdom.dlpay.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class SystemServiceImpl implements SystemService {
    @Autowired
    private DictionaryDao dictionaryDao;
    @Override
    public Pagination findDictionary(String dicttype, String dictcaption, Integer pageNo, Integer pageSize) {
        return dictionaryDao.findDictionary(dicttype, dictcaption, pageNo, pageSize);
    }

    @Override
    public List<DictionaryType> findDictionaryType() {
        return dictionaryDao.findDictionaryType();
    }

    @Override
    public boolean saveDictionary(String dicttype, String dicttypename, String dictval, String dictcaption) {
        TDictionary tDictionary = new TDictionary();
        TDictionaryId tDictionaryId = new TDictionaryId();
        tDictionaryId.setDicttype(Integer.parseInt(dicttype));
        tDictionaryId.setDicttypename(dicttypename);
        tDictionaryId.setDictval(dictval);
        tDictionaryId.setDictcaption(dictcaption);
        tDictionary.setId(tDictionaryId);
        boolean b = dictionaryDao.saveDictionary(tDictionary);
        return b;
    }

    @Override
    public List<TDictionaryId> findTDictionaryByType(int type) {
        return dictionaryDao.findTDictionaryByType(type);
    }

    @Override
    public List<TDictionaryId> findByType(int type, String dicVal) {
        return dictionaryDao.findByType(type, dicVal);
    }

    @Override
    public TDictionary updateDictionary(String dicttype, String dicttypename, String dictval, String dictcaption, String oriengaltype, String oriengalval) {
        return dictionaryDao.updateDictionary(dicttype, dicttypename, dictval, dictcaption, oriengaltype, oriengalval);
    }
}
