package com.supwisdom.dlpay.framework.controller

import com.jcabi.manifests.Manifests
import com.supwisdom.dlpay.framework.ResponseBodyBuilder
import org.springframework.http.ResponseEntity
import org.springframework.web.bind.annotation.GetMapping
import org.springframework.web.bind.annotation.RequestMapping
import org.springframework.web.bind.annotation.RestController


@RestController
@RequestMapping("/common")
class AboutController {
    @GetMapping("/version")
    fun version(): ResponseEntity<Any> {
        return try {
            Manifests.read("Payapi-Version").let {
                ResponseEntity.ok(ResponseBodyBuilder.create()
                        .data("version", it)
                        .success())
            }
        } catch (e: Throwable) {
            ResponseEntity.ok(ResponseBodyBuilder.create()
                    .data("version", "unknown")
                    .success())
        }
    }
}