package com.supwisdom.dlpay.consume.dao;

import com.supwisdom.dlpay.consume.domain.TUserdtl;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.stereotype.Repository;

import javax.persistence.LockModeType;
import javax.persistence.QueryHint;

@Repository
public interface UserdtlDao extends JpaRepository<TUserdtl, String> {
  TUserdtl findByRefno(String refno);

  @Lock(LockModeType.PESSIMISTIC_WRITE)
  @QueryHints({@QueryHint(name = "javax.persistence.lock.timeout", value ="0")})
  @Query("select dtl from TUserdtl  dtl where dtl.refno = ?1")
  TUserdtl findByRefnoForUpdate(String refno);
}
