package com.supwisdom.dlpay.consume.service.impl;

import com.supwisdom.dlpay.consume.dao.PaytypeConfigDao;
import com.supwisdom.dlpay.consume.dao.PaytypeDao;
import com.supwisdom.dlpay.consume.domain.TPaytype;
import com.supwisdom.dlpay.consume.domain.TPaytypeConfig;
import com.supwisdom.dlpay.consume.service.PaytypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by shuwei on 2019/4/9.
 */
@Service
public class PaytypeServiceImpl implements PaytypeService {
  @Autowired
  private PaytypeDao paytypeDao;
  @Autowired
  private PaytypeConfigDao paytypeConfigDao;

  @Override
  public TPaytype getByPaytype(String paytype) {
    return paytypeDao.getOne(paytype);
  }

  @Override
  public Map<String, String> getPaytypeConfigByPaytype(String pattype) {
    List<TPaytypeConfig> list = paytypeConfigDao.getByPaytype(pattype);
    Map<String, String> map = new HashMap<>(list.size());
    for (TPaytypeConfig paytypeConfig : list) {
      map.put(paytypeConfig.getConfigid(), paytypeConfig.getConfigValue());
    }
    return map;
  }
}
