package com.supwisdom.dlpay.framework

import com.supwisdom.dlpay.exception.TransactionCheckException
import com.supwisdom.dlpay.framework.util.TradeErrorCode

class ResponseBodyBuilder private constructor() {
    companion object {
        private const val INVALIDE_RETCODE = -0x7FFFFFFF
        private val RESERVED_KEY = setOf("retcode", "retmsg", "exception")
        fun create() = ResponseBodyBuilder()
    }

    private var retCode = INVALIDE_RETCODE
    private var retMsg = ""

    private val respData = mutableMapOf<String, Any>()

    fun result(code: Int, msg: String? = null): ResponseBodyBuilder {
        this.retCode = code
        retMsg = if (retCode == 0) {
            msg ?: "成功"
        } else {
            msg ?: "失败"
        }
        return this
    }

    fun success(msg: String? = null): ResponseBodyBuilder {
        result(0, msg)
        return this
    }

    fun exception(code: Int, exception: Exception, msg: String? = null): ResponseBodyBuilder {
        data("exception", exception.message ?: "$exception")
        return result(code, msg)
    }

    fun data(name: String, value: Any): ResponseBodyBuilder {
        if(name in RESERVED_KEY) {
            throw TransactionCheckException(TradeErrorCode.INPUT_DATA_ERROR, "返回值 <$name> 为保留值，不能使用")
        }
        this.respData[name] = value
        return this
    }

    fun build(): Map<String, Any> {
        if (retCode == INVALIDE_RETCODE) {
            throw TransactionCheckException(TradeErrorCode.INPUT_DATA_ERROR, "未设置返回码!")
        }
        return this.respData.plus(mapOf("retcode" to retCode, "retmsg" to retMsg))
    }
}