package com.supwisdom.dlpay.shop.controller

import com.supwisdom.dlpay.framework.ResponseBodyBuilder
import com.supwisdom.dlpay.framework.domain.TShop
import com.supwisdom.dlpay.framework.service.SystemUtilService
import com.supwisdom.dlpay.framework.util.TradeDict
import com.supwisdom.dlpay.shop.bean.ShopParam
import com.supwisdom.dlpay.shop.service.ShopService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.http.ResponseEntity
import org.springframework.web.bind.annotation.*

/**
 * 接口签名值等
 */
@RestController
@RequestMapping("/shop")
class ShopController {
    @Autowired
    private lateinit var shopService: ShopService

    @PostMapping("/open")
    fun openAccount(@RequestBody request: ShopParam): ResponseEntity<Any> {
        if (request.uniqueId != null && request.uniqueId != "") {
            var shop = shopService.findByThirdUniqueId(request.uniqueId!!)
            if (shop != null) {
                return ResponseEntity.ok(ResponseBodyBuilder.create()
                        .result(1, "[uniqueId]该值已存在")
                        .build())
            }
        }
        val shop = TShop()
        shop.addr = request.addr
        shop.contactman = request.contactman
        shop.mobile = request.mobile
        shop.shopname = request.shopname
        shop.status = TradeDict.STATUS_NORMAL
        shop.thirdUniqueIdenty = request.uniqueId
        shopService.save(shop)
        return ResponseEntity.ok(ResponseBodyBuilder.create()
                .success()
                .data("shopid", shop.shopid)
                .build())
    }

    @GetMapping("/get")
    fun queryShop(@RequestBody request: ShopParam): ResponseEntity<Any> {
        if (request.uniqueId != null && request.uniqueId != "") {
            var shop = shopService.findByThirdUniqueId(request.uniqueId!!)
            if (shop != null) {
                return ResponseEntity.ok(ResponseBodyBuilder.create()
                        .success()
                        .data("shop", shop)
                        .build())
            }
        } else if (request.shopid != null && request.shopid != 0) {
            var shop = shopService.findByShopId(request.shopid!!)
            if (shop != null) {
                return ResponseEntity.ok(ResponseBodyBuilder.create()
                        .success()
                        .data("shop", shop)
                        .build())
            }
        }
        return ResponseEntity.ok(ResponseBodyBuilder.create()
                .result(1, "数据不存在")
                .build())
    }


}