package com.supwisdom.dlpay.shop.service.impl

import com.supwisdom.dlpay.framework.dao.ShopDao
import com.supwisdom.dlpay.framework.dao.ShopaccDao
import com.supwisdom.dlpay.framework.domain.TShop
import com.supwisdom.dlpay.framework.domain.TShopacc
import com.supwisdom.dlpay.framework.service.SystemUtilService
import com.supwisdom.dlpay.shop.service.ShopService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

/**
 * Created by shuwei on 2019/4/15.
 */
@Service
class ShopServiceImpl : ShopService {
    @Autowired
    private lateinit var shopDao: ShopDao
    @Autowired
    private lateinit var shopaccDao: ShopaccDao
    @Autowired
    private lateinit var systemUtilService: SystemUtilService

    override fun findByThirdUniqueId(uniqueId: String): TShop? {
       return shopDao.getByThirdUniqueIdenty(uniqueId)
    }

    override fun save(shop: TShop): TShop {
        var systemdatetime = systemUtilService.sysdatetime
        shop.opendate = systemdatetime.hostdate
        shopDao.save(shop)
        var shopacc = shopaccDao.findByShopid(shop.shopid)
        if (shopacc == null) {
            shopacc = TShopacc()
            shopacc.shopid = shop.shopid
            shopacc.shopname = shop.shopname
            shopacc.status = shop.status
            shopacc.subjno = "2004"
            shopacc.opendate = systemdatetime.hostdate
            shopacc.shopaccno = String.format("2%09d",shop.shopid)
            shopaccDao.save(shopacc)
        }
        return shop
    }

    override fun findByShopId(shopid: Int): TShop? {
        return shopDao.getOne(shopid)
    }
}