package com.supwisdom.dlpay.user.controller

import com.supwisdom.dlpay.consume.domain.TPerson
import com.supwisdom.dlpay.framework.ResponseBodyBuilder
import com.supwisdom.dlpay.framework.util.TradeDict
import com.supwisdom.dlpay.shop.bean.UserParam
import com.supwisdom.dlpay.user.service.UserService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.http.ResponseEntity
import org.springframework.web.bind.annotation.*

/**
 * Created by shuwei on 2019/4/15.
 */
@RestController
@RequestMapping("/user")
class UserController {
    @Autowired
    private lateinit var useService: UserService

    @PostMapping("/open")
    fun openAccount(@RequestBody request: UserParam): ResponseEntity<Any> {
        if (request.uniqueId != null && request.uniqueId != "") {
            var person = useService.findByThirdUniqueIdenty(request.uniqueId!!)
            if (person != null) {
                return ResponseEntity.ok(ResponseBodyBuilder.create()
                        .result(1, "[uniqueId]该值已存在")
                        .build())
            }
        }
        if (request.name == null) {
            return ResponseEntity.ok(ResponseBodyBuilder.create()
                    .result(1, "[name]不能为空")
                    .build())
        }
        val person = TPerson()
        person.addr = request.addr
        person.name = request.name
        person.mobile = request.mobile
        person.status = TradeDict.STATUS_NORMAL
        person.thirdUniqueIdenty = request.uniqueId
        useService.save(person)
        return ResponseEntity.ok(ResponseBodyBuilder.create()
                .success()
                .data("userid", person.userid)
                .build())
    }

    @GetMapping("/get")
    fun queryShop(@RequestBody request: UserParam): ResponseEntity<Any> {
        if (request.uniqueId != null && request.uniqueId != "") {
            var person = useService.findByThirdUniqueIdenty(request.uniqueId!!)
            if (person != null) {
                var account = useService.findAccountByUserid(person.userid)
                return ResponseEntity.ok(ResponseBodyBuilder.create()
                        .success()
                        .data("person", person)
                        .data("account", account!!)
                        .build())
            }
        } else if (request.userid != null && request.userid != "") {
            var person = useService.findPersonByUserid(request.userid!!)
            if (person != null) {
                var account = useService.findAccountByUserid(person.userid)
                return ResponseEntity.ok(ResponseBodyBuilder.create()
                        .success()
                        .data("person", person)
                        .data("account", account!!)
                        .build())
            }
        }
        return ResponseEntity.ok(ResponseBodyBuilder.create()
                .result(1, "数据不存在")
                .build())
    }
}