package com.supwisdom.dlpay.user.service.impl

import com.supwisdom.dlpay.consume.dao.AccountDao
import com.supwisdom.dlpay.consume.dao.PersonDao
import com.supwisdom.dlpay.consume.domain.TAccount
import com.supwisdom.dlpay.consume.domain.TPerson
import com.supwisdom.dlpay.framework.service.SystemUtilService
import com.supwisdom.dlpay.user.service.UserService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

/**
 * Created by shuwei on 2019/4/15.
 */
@Service
class UserServiceImpl : UserService {
    @Autowired
    private lateinit var personDao: PersonDao
    @Autowired
    private lateinit var accountDao: AccountDao
    @Autowired
    private lateinit var systemUtilService: SystemUtilService

    override fun save(person: TPerson): TPerson {
        personDao.save(person)
        var account = accountDao.findByUserid(person.userid)
        if (account == null) {
            var systemdatetime = systemUtilService.sysdatetime
            account = TAccount()
            account.accname = person.name
            account.opendate = systemdatetime.hostdate
            account.userid = person.userid
            account.status = person.status
            account.subjno = "220201"
            account.balance = 0.0
            account.availbal = 0.0
            account.frozebal = 0.0
            account.lowfreeFlag = false
            accountDao.save(account)
        }
        return person
    }

    override fun findByThirdUniqueIdenty(thirdUniqueIdenty: String): TPerson? {
        return personDao.findByThirdUniqueIdenty(thirdUniqueIdenty)
    }

    override fun findPersonByUserid(userid: String): TPerson? {
        return personDao.getOne(userid)
    }

    override fun findAccountByUserid(userid: String): TAccount? {
        return accountDao.findByUserid(userid)
    }
}