package com.supwisdom.dlpay.consume.controller;

import com.supwisdom.dlpay.consume.bean.BaseResp;
import com.supwisdom.dlpay.framework.data.SystemDateTime;
import com.supwisdom.dlpay.framework.service.SystemUtilService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Controller //将所有方法标识@ResponseBody注解
@RequestMapping("/test")
public class TestAction {
  @Autowired
  private SystemUtilService systemUtilService;

  @RequestMapping("/demo")
  @ResponseBody
  public BaseResp test() {
    SystemDateTime dt = systemUtilService.getSysdatetime();

    BaseResp resp = new BaseResp();
    resp.setRetcode("0");
    resp.setRetmsg("OK");
    resp.setData("hostdate=["+dt.getHostdate()+"],hosttime=["+dt.getHosttime()+"],hostdatetime=["+dt.getHostdatetime()+"],date=["+dt.getSysdate()+"]");
    return resp;
  }
}
