package com.supwisdom.dlpay.framework.dao;

import com.supwisdom.dlpay.framework.domain.TSettlectl;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import javax.persistence.LockModeType;

@Repository
public interface SettleCtlDao extends JpaRepository<TSettlectl, Integer> {
  @Lock(value = LockModeType.PESSIMISTIC_WRITE)
  TSettlectl findByBooksetno(Integer booksetno);

  @Lock(value = LockModeType.PESSIMISTIC_WRITE)
  @Query(value = "from TSettlectl where booksetno=:booksetno ")
  TSettlectl findByBooksetnoWithLock(@Param("booksetno") Integer booksetno);

  @Query(value = "update TB_SETTLECTL set PERIOD_YEAR=:peridyear,PERIOD_MONTH=:peridmonth where BOOKSETNO=1 ", nativeQuery = true)
  void updateSettlePeriod(@Param("peridyear") int peridyear, @Param("peridmonth") int peridmonth);

}
