package com.supwisdom.dlpay.framework.util;

public class TradeDict {
  /**
   * 状态：
   * normal -- 正常
   * closed -- 注销
   * locked -- 锁定、冻结
   */
  public static final String STATUS_NORMAL = "normal";
  public static final String STATUS_CLOSED = "closed";
  public static final String STATUS_LOCKED = "locked";

  /**
   * 流水状态
   * temp -- 临时流水
   * init -- 初始化流水
   * success -- 交易成功
   * fail -- 交易失败
   * cancel -- 交易取消
   */
  public static final String DTL_STATUS_TEMP = "temp";
  public static final String DTL_STATUS_INIT = "init";
  public static final String DTL_STATUS_SUCCESS = "success";
  public static final String DTL_STATUS_FAIL = "fail";
  public static final String DTL_STATUS_CANCEL = "cancel";
  public static final String DTL_STATUS_WIP = "wip";

  /**
   * 交易借方
   */
  public static final String TRANS_DIRECTION_CREDIT = "credit";
  public static final String TRANS_DIRECTION_DEBIT = "debit";


  /**
   * 支付方式
   * */
  public static final String PAYTYPE_CASH="cash";
  public static final String PAYTYPE_BALANCE="balance";


  /**
   * feetype
   * - 消费：折扣、搭伙费（管理费）
   * - 充值：优惠、服务费（手续费）
   * */

  public static final String FEETYPE_CONSUME_MEALER="mealer"; //收管理费
  public static final String FEETYPE_CONSUME_DISCOUNT="discount"; //折扣款抵扣

  public static final String PAYTYPE_RECHARGE_COUPON="coupon";  // 充值优惠
  public static final String PAYTYPE_RECHARGE_SERVICEFEE="servicefee"; //收服务费
}
