package com.supwisdom.dlpay

import org.springframework.beans.factory.annotation.Autowired
import org.springframework.boot.autoconfigure.SpringBootApplication
import org.springframework.boot.runApplication
import org.springframework.context.annotation.Bean
import org.springframework.context.annotation.ComponentScan
import org.springframework.context.annotation.Configuration
import org.springframework.context.annotation.PropertySource
import org.springframework.core.annotation.Order
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder
import org.springframework.security.config.annotation.web.builders.HttpSecurity
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter
import org.springframework.security.config.http.SessionCreationPolicy
import org.springframework.security.core.Authentication
import org.springframework.security.core.userdetails.User
import org.springframework.security.core.userdetails.UserDetailsService
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository
import org.springframework.security.provisioning.InMemoryUserDetailsManager
import org.springframework.security.web.authentication.logout.CookieClearingLogoutHandler
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer
import org.springframework.security.web.context.AbstractSecurityWebApplicationInitializer
import javax.servlet.http.HttpServletRequest
import javax.servlet.http.HttpServletResponse


@EnableWebSecurity
class WebSecurityConfig {
    @Autowired
    private lateinit var clientRegistrationRepository: ClientRegistrationRepository

    @Bean
    fun userDetailsService(): UserDetailsService {
        val manager = InMemoryUserDetailsManager()
        manager.createUser(User.withDefaultPasswordEncoder()
                .username("admin")
                .password("123456")
                .roles("USER").build())
        return manager
    }

    companion object {
        @Configuration
        @Order(1)
        class ApiWebSecurityConfigurationAdapter : WebSecurityConfigurerAdapter() {
            @Autowired
            private lateinit var clientRegistrationRepository: ClientRegistrationRepository

            override fun configure(http: HttpSecurity) {
                http.authorizeRequests()
//                        .antMatchers("/login", "/resources/**", "/about", "/common/**").permitAll()
//                        .antMatchers("/admin/**").hasRole("ADMIN")
//                        .antMatchers("/db/**").access("hasRole('ADMIN') and hasRole('DBA')")
                        .antMatchers("/**").permitAll()
                        .antMatchers("/admin/**").hasRole("ADMIN")
                        .anyRequest().authenticated()
                        .and().httpBasic()
                        .and()
                        .sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS)
//                        .oauth2Client()
//                        .clientRegistrationRepository(clientRegistrationRepository)
//                        .authorizedClientRepository(this.authorizedClientRepository())
//                        .authorizedClientService(this.authorizedClientService())
//                        .authorizationCodeGrant()
//                        .authorizationRequestRepository(this.authorizationRequestRepository())
//                        .authorizationRequestResolver(this.authorizationRequestResolver())
//                        .accessTokenResponseClient(this.accessTokenResponseClient())
            }
        }


        @Configuration
        class MvcWebSecurityConfigurationAdapter : WebSecurityConfigurerAdapter() {

            override fun configure(http: HttpSecurity) {
                http.authorizeRequests()
                        .anyRequest().authenticated()
                        .and()
                        .formLogin()
                        .loginPage("/user/login").permitAll()
                        .and()
                        .logout()
                        .logoutUrl("/user/logout")
                        .logoutSuccessUrl("/user/home")
                        .invalidateHttpSession(true)
                        .addLogoutHandler(CookieClearingLogoutHandler())
            }
        }
    }
}


@SpringBootApplication
class DlpayApplication

fun main(args: Array<String>) {
    runApplication<DlpayApplication>(*args)
}
