package com.supwisdom.dlpay.user.service

import com.supwisdom.dlpay.consume.domain.TAccount
import com.supwisdom.dlpay.consume.domain.TPerson
import org.springframework.transaction.annotation.Propagation
import org.springframework.transaction.annotation.Transactional

/**
 * Created by shuwei on 2019/4/15.
 */
interface UserService {
    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class))
    fun save(person: TPerson): TPerson

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class), readOnly = true)
    fun findByThirdUniqueIdenty(thirdUniqueIdenty: String): TPerson?

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class), readOnly = true)
    fun findPersonByUserid(userid: String): TPerson?

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = arrayOf(Exception::class), readOnly = true)
    fun findAccountByUserid(userid: String): TAccount?
}