package com.supwisdom.dlpay.consume.dao;

import com.supwisdom.dlpay.consume.domain.TAccount;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Query;
import org.springframework.web.bind.annotation.RequestParam;

import javax.persistence.LockModeType;

public interface AccountDao extends JpaRepository<TAccount, String> {

  @Lock(LockModeType.PESSIMISTIC_WRITE)
  @Query("select a from TAccount a where a.accno = ?1")
  TAccount getByAccnoForUpdate(String accno);


  TAccount findByUserid(String userid);
}
