package com.supwisdom.dlpay.framework.dao;

import com.supwisdom.dlpay.framework.data.ExistBean;
import com.supwisdom.dlpay.framework.domain.TShopacc;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface ShopaccDao extends JpaRepository<TShopacc, String> {

  @Query(value = "select t.SHOPACCNO as accno from TB_SHOPACC t left join TB_SHOPACCBAL a on t.SHOPACCNO=a.SHOPACCNO where a.SHOPACCNO is null ", nativeQuery = true)
  List<String> getNewShopacc();

  @Query(value = "select count(t.shopaccno) as existed from TB_SHOPACC t left join TB_SHOPACCBAL a on t.SHOPACCNO=a.SHOPACCNO where a.SHOPACCNO is null and t.STATUS='normal' ", nativeQuery = true)
  ExistBean checkSettleShopacc();

  @Query(value = "select shopname from TShopacc where shopaccno=:shopaccno ")
  String getShopname(@Param("shopaccno") String shopaccno);

  @Query(value = "select t.SHOPACCNO as accno from TB_SHOPACC t left join TB_SHOPACCBAL a on t.SHOPACCNO=a.SHOPACCNO where a.SHOPACCNO is null and t.opendate>=:settday ", nativeQuery = true)
  List<String> getNewAddShopacc(@Param("settday") String settday);

  TShopacc findByShopid(Integer shopid);
}
