package com.supwisdom.dlpay.framework.util;

public class TradeErrorCode {

  public static final int OK = 0;

  /**
   * 10000 开始表示交易数据错误
   */
  public static final int INPUT_DATA_ERROR = 10000;


  /**
   * 账户不存在
   * */
  public static final int ACCOUNT_NOT_EXISTS = 10001;

  /**
   * 账户余额不足
   */
  public static final int SHORT_BALANCE_ERROR = 10002;

  /**
   * 个人账户状态异常
   */
  public static final int PERSON_STATUS_ERROR = 10003;

  /**
   * 交易记录不存在
   */
  public static final int TRANSACTION_NOT_EXISTS = 10004;

  /**
   * 交易状态已完成
   */
  public static final int TRANSACTION_IS_FINISHED = 10005;

  /**
   * 交易已冲正
   */
  public static final int TRANSACTION_HAS_CANCELED = 10006;
  /**
   * 商户不存在
   * */
  public static final int SHOP_NOT_EXISTS = 10007;

  /**
   * 商户不存在
   * */
  public static final int SUBJECT_NOT_EXISTS = 10008;

  /**
   * 外部流水号重复
   * */
  public static final int OUTTRADENO_ALREADY_EXISTS = 10009;

  /**
   * 账户TAC校验异常
   * */
  public static final int ACCOUNT_TAC_ERROR = 10010;

  /**
   * 账户余额超上限
   * */
  public static final int OVERFLOW_BALANCE_ERROR = 10011;

  /**
   * 未指定明确的交易结束状态
   * */
  public static final int TRANSDTL_STATUS_ERROR = 10012;

  /**
   * 非初始化流水
   * */
  public static final int TRANSDTL_STATUS_NOT_INIT = 10013;

}
