package com.supwisdom.dlpay.consume.controller

import com.supwisdom.dlpay.consume.AccountHolder
import com.supwisdom.dlpay.consume.CallService
import com.supwisdom.dlpay.consume.PersonTransBuilder
import com.supwisdom.dlpay.consume.domain.TUserdtl
import com.supwisdom.dlpay.consume.service.AccountUtilServcie
import com.supwisdom.dlpay.consume.service.PaytypeService
import com.supwisdom.dlpay.consume.service.PersonBalancePayService
import com.supwisdom.dlpay.consume.service.PersonService
import com.supwisdom.dlpay.framework.util.DateUtil
import com.supwisdom.dlpay.framework.util.TradeCode
import com.supwisdom.dlpay.framework.util.TradeDict
import com.supwisdom.dlpay.framework.util.Tradetype
import com.supwisdom.dlpay.util.PaytypeUtil
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.http.ResponseEntity
import org.springframework.web.bind.annotation.GetMapping
import org.springframework.web.bind.annotation.PostMapping
import org.springframework.web.bind.annotation.RestController

@RestController
class ConsumeController {
    @Autowired
    lateinit var accountUtilServcie: AccountUtilServcie

    @Autowired
    lateinit var personBalancePayService: PersonBalancePayService

    @Autowired
    lateinit var paytypeService: PaytypeService
    @Autowired
    lateinit var personService: PersonService

    @PostMapping("/account/pay")
    fun accountPay(userid: String, amount: Int, manageFee: Int): ResponseEntity<Any> {
        val dtl = PersonTransBuilder.newBuilder(accountUtilServcie)
                .setTransDatetime("20190411", "112311")
                .enableOverdraft(false)
                .addDetail(AccountHolder.person(userid),
                        AccountHolder.shop("12323"),
                        amount / 100.0, "")
                .addDetail(AccountHolder.person(userid), AccountHolder.transType(301),
                        manageFee / 100.0, "")
                .done(personBalancePayService, true)
        return ResponseEntity.ok(dtl)
    }

    @GetMapping("/account/payinit")
    fun accountPayInit(userid: String, amount: Int, manageFee: Int): ResponseEntity<Any> {
        val dtl = PersonTransBuilder.newBuilder(accountUtilServcie)
                .setTransDatetime("20190411", "112311")
                .enableOverdraft(false)
                .addDetail(AccountHolder.person(userid),
                        AccountHolder.shop("12323"),
                        amount / 100.0, "")
                .addDetail(AccountHolder.person(userid), AccountHolder.transType(301),
                        manageFee / 100.0, "")
                .done(personBalancePayService, false)

        return ResponseEntity.ok(dtl)
    }

    @GetMapping("/account/payfinish")
    fun accountPayFinish(refno: String): ResponseEntity<Any> {
        val dtl = PersonTransBuilder.newBuilder(accountUtilServcie)
                .done(refno, TradeDict.DTL_STATUS_SUCCESS, personBalancePayService)
        return ResponseEntity.ok(dtl)
    }

    @PostMapping("/ykt/payinit")
    fun yktPayInit(userid: String, amount: Int, manageFee: Int,
                   stuempno: String, shopid: String, transdate: String, transtime: String,
                   outtradeno: String, payinfo: String,feetype:String): ResponseEntity<Any> {
        //一卡通支付款 112240
        var fee_drsubjectno = ""
        var fee_crsubjectno = ""
        var summary = ""
        var realamount = 0
        when(feetype){
            TradeDict.FEETYPE_CONSUME_MEALER->{
                fee_drsubjectno="112240"
                fee_crsubjectno = "2002"
                realamount = amount
                summary = "收搭伙费"
            }
            TradeDict.FEETYPE_CONSUME_DISCOUNT->{
                fee_drsubjectno = "2003"
                fee_crsubjectno = shopid
                realamount = amount - manageFee
                summary = "优惠折扣"
            }
        }

        var person = personService.getPersonByThirdUniqueIdenty(stuempno)
        val dtl = PersonTransBuilder.newBuilder(accountUtilServcie)
                .setTransDatetime(transdate, transtime)
                .selectPaytype(PaytypeUtil.YKTPAY, payinfo)
                .setOuttradeno(outtradeno)
                .setOwner(person)
                .setTransinfo(TradeCode.TRANSCODE_YKTPAY,"一卡通支付")
                .chooseTradetype(Tradetype.CONSUME)
                .addDetail(AccountHolder.subject("112240"),
                        AccountHolder.shop(shopid),
                        realamount / 100.0, "一卡通支付")
                .addDetail(AccountHolder.subject(fee_drsubjectno),
                        AccountHolder.subject(fee_crsubjectno),
                        manageFee / 100.0, summary)
                .done(personBalancePayService, false)
        return ResponseEntity.ok(dtl)
    }

    @PostMapping("/ykt/payfinish")
    fun yktPayFinish(refno: String, yktshopid: String, devphyid: String?): ResponseEntity<Any> {
        var dtl = personBalancePayService.wip(refno)
        var person = personService.getPersonByUserid(dtl.userid)
        val code = CallService.callYktPay(paytypeService.getPaytypeConfigByPaytype(PaytypeUtil.YKTPAY),
                dtl, DateUtil.getNow(),person?.thirdUniqueIdenty,yktshopid,devphyid)
        return if (code.retcode == "0") {
            val suc = PersonTransBuilder.newBuilder(accountUtilServcie)
                    .done(dtl.refno, TradeDict.DTL_STATUS_SUCCESS, personBalancePayService)
            ResponseEntity.ok(suc)
        } else {
            val fail = PersonTransBuilder.newBuilder(accountUtilServcie)
                    .done(dtl.refno, TradeDict.DTL_STATUS_FAIL, personBalancePayService)
            ResponseEntity.ok(fail)
        }
    }
}